/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util.ai;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.theokanning.openai.completion.chat.ChatCompletionChoice;
import com.theokanning.openai.completion.chat.ChatCompletionRequest;
import com.theokanning.openai.completion.chat.ChatCompletionResult;
import com.theokanning.openai.completion.chat.ChatMessage;
import com.theokanning.openai.completion.chat.ChatMessageRole;
import io.github.microcks.domain.Exchange;
import io.github.microcks.domain.Operation;
import io.github.microcks.domain.Resource;
import io.github.microcks.domain.Service;
import io.github.microcks.domain.ServiceType;
import io.github.microcks.util.ai.AICopilot;
import io.github.microcks.util.ai.AICopilotHelper;
import io.github.microcks.util.ai.ChatCompletionRequestMixIn;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class OpenAICopilot
implements AICopilot {
    private static Logger log = LoggerFactory.getLogger(OpenAICopilot.class);
    public static final String API_KEY_CONFIG = "api-key";
    public static final String API_URL_CONFIG = "api-url";
    public static final String TIMEOUT_KEY_CONFIG = "timeout";
    public static final String MODEL_KEY_CONFIG = "model";
    public static final String MAX_TOKENS_KEY_CONFIG = "maxTokens";
    protected static final String[] MANDATORY_CONFIG_KEYS = new String[]{"api-key"};
    private static final String OPENAI_BASE_URL = "https://api.openai.com/";
    private static final String SECTION_DELIMITER = "\n###\n";
    private RestTemplate restTemplate;
    private String apiUrl = "https://api.openai.com/";
    private String apiKey;
    private Duration timeout = Duration.ofSeconds(20L);
    private String model = "gpt-3.5-turbo";
    private int maxTokens = 2000;

    public OpenAICopilot(Map<String, String> configuration) {
        if (configuration.containsKey(TIMEOUT_KEY_CONFIG)) {
            try {
                this.timeout = Duration.ofSeconds(Integer.parseInt(configuration.get(TIMEOUT_KEY_CONFIG)));
            }
            catch (Exception e) {
                log.warn("Timeout was provided but cannot be parsed. Sticking to the default.");
            }
        }
        if (configuration.containsKey(MAX_TOKENS_KEY_CONFIG)) {
            try {
                this.maxTokens = Integer.parseInt(configuration.get(MAX_TOKENS_KEY_CONFIG));
            }
            catch (Exception e) {
                log.warn("MaxTokens was provided but cannot be parsed. Sticking to the default.");
            }
        }
        if (configuration.containsKey(MODEL_KEY_CONFIG)) {
            this.model = configuration.get(MODEL_KEY_CONFIG);
        }
        if (configuration.containsKey(API_URL_CONFIG)) {
            this.apiUrl = configuration.get(API_URL_CONFIG);
        }
        this.apiKey = configuration.get(API_KEY_CONFIG);
        this.restTemplate = new RestTemplateBuilder(new RestTemplateCustomizer[0]).setReadTimeout(this.timeout).additionalMessageConverters(new HttpMessageConverter[]{this.mappingJacksonHttpMessageConverter()}).build();
    }

    public static final String[] getMandatoryConfigKeys() {
        return MANDATORY_CONFIG_KEYS;
    }

    @Override
    public List<? extends Exchange> suggestSampleExchanges(Service service, Operation operation, Resource contract, int number) throws Exception {
        String prompt = "";
        if (service.getType() == ServiceType.REST) {
            prompt = this.preparePromptForOpenAPI(operation, contract, number);
        } else if (service.getType() == ServiceType.GRAPHQL) {
            prompt = this.preparePromptForGraphQL(operation, contract, number);
        } else if (service.getType() == ServiceType.EVENT) {
            prompt = this.preparePromptForAsyncAPI(operation, contract, number);
        } else if (service.getType() == ServiceType.GRPC) {
            prompt = this.preparePromptForGrpc(service, operation, contract, number);
        }
        log.debug("Asking OpenAI to suggest samples for this prompt: {}", (Object)prompt);
        ArrayList<ChatMessage> messages = new ArrayList<ChatMessage>();
        ChatMessage assistantMessage = new ChatMessage(ChatMessageRole.ASSISTANT.value(), prompt);
        messages.add(assistantMessage);
        ChatCompletionRequest chatCompletionRequest = ChatCompletionRequest.builder().model(this.model).messages(messages).n(Integer.valueOf(1)).maxTokens(Integer.valueOf(this.maxTokens)).logitBias(new HashMap()).build();
        HttpEntity request = new HttpEntity((Object)chatCompletionRequest, (MultiValueMap)this.createAuthenticationHeaders());
        ChatCompletionResult completionResult = (ChatCompletionResult)this.restTemplate.exchange(this.apiUrl + "/v1/chat/completions", HttpMethod.POST, request, ChatCompletionResult.class, new Object[0]).getBody();
        if (completionResult != null) {
            ChatCompletionChoice choice = (ChatCompletionChoice)completionResult.getChoices().get(0);
            log.debug("Got this raw output from OpenAI: {}", (Object)choice.getMessage().getContent());
            if (service.getType() == ServiceType.EVENT) {
                return AICopilotHelper.parseUnidirectionalEventTemplateOutput(choice.getMessage().getContent());
            }
            return AICopilotHelper.parseRequestResponseTemplateOutput(service, operation, choice.getMessage().getContent());
        }
        return new ArrayList();
    }

    private String preparePromptForOpenAPI(Operation operation, Resource contract, int number) throws Exception {
        StringBuilder prompt = new StringBuilder(AICopilotHelper.getOpenAPIOperationPromptIntro(operation.getName(), number));
        prompt.append("\n");
        prompt.append("Use only this YAML format for output (no other text or markdown):\n");
        prompt.append("\n");
        prompt.append(AICopilotHelper.getRequestResponseExampleYamlFormattingDirective(1));
        prompt.append(SECTION_DELIMITER);
        prompt.append(AICopilotHelper.removeTokensFromSpec(contract.getContent(), operation.getName()));
        return prompt.toString();
    }

    private String preparePromptForGraphQL(Operation operation, Resource contract, int number) {
        StringBuilder prompt = new StringBuilder(AICopilotHelper.getGraphQLOperationPromptIntro(operation.getName(), number));
        if ("QUERY_ARGS".equals(operation.getDispatcher())) {
            StringBuilder variablesList = new StringBuilder();
            if (operation.getDispatcherRules().contains("&&")) {
                String[] variables = operation.getDispatcherRules().split("&&");
                for (int i = 0; i < variables.length; ++i) {
                    String variable = variables[i];
                    variablesList.append("$").append(variable.trim());
                    if (i >= variables.length - 1) continue;
                    variablesList.append(", ");
                }
            } else {
                variablesList.append("$").append(operation.getDispatcherRules());
            }
            prompt.append("Use only '").append((CharSequence)variablesList).append("' as variable identifiers.");
        }
        prompt.append("\n");
        prompt.append("Use only this YAML format for output (no other text or markdown):\n");
        prompt.append("\n");
        prompt.append(AICopilotHelper.getRequestResponseExampleYamlFormattingDirective(1));
        prompt.append(SECTION_DELIMITER);
        prompt.append(contract.getContent());
        return prompt.toString();
    }

    private String preparePromptForAsyncAPI(Operation operation, Resource contract, int number) throws Exception {
        StringBuilder prompt = new StringBuilder(AICopilotHelper.getAsyncAPIOperationPromptIntro(operation.getName(), number));
        prompt.append("\n");
        prompt.append("Use only this YAML format for output (no other text or markdown):\n");
        prompt.append("\n");
        prompt.append(AICopilotHelper.getUnidirectionalEventExampleYamlFormattingDirective(1));
        prompt.append(SECTION_DELIMITER);
        prompt.append(AICopilotHelper.removeTokensFromSpec(contract.getContent(), operation.getName()));
        return prompt.toString();
    }

    private String preparePromptForGrpc(Service service, Operation operation, Resource contract, int number) throws Exception {
        StringBuilder prompt = new StringBuilder(AICopilotHelper.getGrpcOperationPromptIntro(service.getName(), operation.getName(), number));
        prompt.append("\n");
        prompt.append("Use only this YAML format for output (no other text or markdown):\n");
        prompt.append("\n");
        prompt.append(AICopilotHelper.getGrpcRequestResponseExampleYamlFormattingDirective(1));
        prompt.append(SECTION_DELIMITER);
        prompt.append(contract.getContent());
        return prompt.toString();
    }

    private MappingJackson2HttpMessageConverter mappingJacksonHttpMessageConverter() {
        MappingJackson2HttpMessageConverter converter = new MappingJackson2HttpMessageConverter();
        converter.setObjectMapper(OpenAICopilot.customObjectMapper());
        return converter;
    }

    private static ObjectMapper customObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.setPropertyNamingStrategy(PropertyNamingStrategies.SNAKE_CASE);
        mapper.addMixIn(ChatCompletionRequest.class, ChatCompletionRequestMixIn.class);
        return mapper;
    }

    private HttpHeaders createAuthenticationHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.set("Authorization", "Bearer " + this.apiKey);
        return headers;
    }
}

