/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util.graphql;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.http.HttpServletRequest;

public class GraphQLHttpRequest {
    String query;
    String operationName;
    JsonNode variables;

    public String getQuery() {
        return this.query;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public JsonNode getVariables() {
        return this.variables;
    }

    public static GraphQLHttpRequest from(String body, HttpServletRequest request) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        GraphQLHttpRequest parameters = new GraphQLHttpRequest();
        if ("POST".equalsIgnoreCase(request.getMethod())) {
            JsonNode json = mapper.readTree(body);
            parameters.query = json.path("query").asText();
            parameters.operationName = json.path("operationName").asText(null);
            parameters.variables = json.get("variables");
        } else {
            parameters.query = request.getParameter("query");
            parameters.operationName = request.getParameter("operationName");
            parameters.variables = GraphQLHttpRequest.getVariables(mapper, request.getParameter("variables"));
        }
        return parameters;
    }

    private static JsonNode getVariables(ObjectMapper mapper, String variables) throws Exception {
        if (variables != null) {
            return mapper.readTree(variables);
        }
        return null;
    }
}

