/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.config;

import io.github.microcks.security.MicrocksJwtConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.security.oauth2.client.servlet.OAuth2ClientAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.HeadersConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.SecurityFilterChain;

@Configuration
@EnableWebSecurity
@EnableAutoConfiguration(exclude={OAuth2ClientAutoConfiguration.class})
public class SecurityConfiguration {
    private static Logger log = LoggerFactory.getLogger(SecurityConfiguration.class);
    @Value(value="${keycloak.enabled}")
    private final Boolean keycloakEnabled = true;

    @Bean
    public SecurityFilterChain configureSecurityFilterChain(HttpSecurity http) throws Exception {
        log.info("Starting security configuration");
        http.sessionManagement(sm -> sm.sessionCreationPolicy(SessionCreationPolicy.STATELESS));
        http.csrf(csrf -> csrf.disable());
        http.cors(cors -> cors.disable());
        if (Boolean.TRUE.equals(this.keycloakEnabled)) {
            log.info("Keycloak is enabled, configuring oauth2 & request authorization");
            http.authorizeHttpRequests(registry -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)registry.requestMatchers(new String[]{"/api/services", "/api/services/*", "/api/jobs", "/api/jobs/*"})).hasAnyRole(new String[]{"user", "manager", "admin"}).requestMatchers(new String[]{"/api/services/*/*"})).hasAnyRole(new String[]{"manager", "admin"}).requestMatchers(new String[]{"/api/jobs/*/*"})).hasAnyRole(new String[]{"manager", "admin"}).requestMatchers(new String[]{"/api/artifact/*"})).hasAnyRole(new String[]{"manager", "admin"}).requestMatchers(new String[]{"/api/import/*", "/api/export/*"})).hasAnyRole(new String[]{"admin"}).requestMatchers(HttpMethod.GET, new String[]{"/api/secrets"})).hasAnyRole(new String[]{"user", "manager", "admin"}).requestMatchers(HttpMethod.GET, new String[]{"/api/secrets/*"})).hasAnyRole(new String[]{"user", "manager", "admin"}).requestMatchers(HttpMethod.POST, new String[]{"/api/secrets"})).hasAnyRole(new String[]{"admin"}).requestMatchers(HttpMethod.PUT, new String[]{"/api/secrets/*"})).hasAnyRole(new String[]{"admin"}).requestMatchers(HttpMethod.DELETE, new String[]{"/api/secrets/*"})).hasAnyRole(new String[]{"admin"}).anyRequest()).permitAll());
            http.oauth2ResourceServer(oauth2Configurer -> oauth2Configurer.jwt(jwtConfigurer -> jwtConfigurer.jwtAuthenticationConverter((Converter)new MicrocksJwtConverter())));
        } else {
            log.info("Keycloak is disabled, permitting all requests");
            http.authorizeHttpRequests(registry -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)registry.anyRequest()).permitAll());
        }
        http.headers(headers -> headers.frameOptions(HeadersConfigurer.FrameOptionsConfig::disable));
        return (SecurityFilterChain)http.build();
    }
}

