/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.web;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/keycloak"})
public class KeycloakConfigController {
    private static Logger log = LoggerFactory.getLogger(KeycloakConfigController.class);
    @Value(value="${keycloak.enabled}")
    private Boolean keycloakEnabled = true;
    @Value(value="${sso.public-url}")
    private String keycloakServerUrl = null;
    @Value(value="${keycloak.realm}")
    private String keycloakRealmName = null;

    @GetMapping(value={"/config"})
    public ResponseEntity<Config> getConfig() {
        Config config = new Config(this.keycloakEnabled, this.keycloakRealmName, this.keycloakServerUrl);
        log.debug("Returning '{}' realm config, for {}", (Object)this.keycloakRealmName, (Object)this.keycloakServerUrl);
        return new ResponseEntity((Object)config, (HttpStatusCode)HttpStatus.OK);
    }

    private class Config {
        @JsonProperty(value="ssl-required")
        private static final String SSL_REQUIRED = "external";
        @JsonProperty(value="public-client")
        private static final boolean PUBLIC_CLIENT = true;
        private static final String RESOURCE = "microcks-app-js";
        private boolean enabled = true;
        private String realm = "microcks";
        @JsonProperty(value="auth-server-url")
        private String authServerUrl = "http://localhost:8180/auth";

        public Config(boolean enabled, String realmName, String authServerUrl) {
            this.enabled = enabled;
            if (realmName != null && !this.realm.isEmpty()) {
                this.realm = realmName;
            }
            if (authServerUrl != null && !authServerUrl.isEmpty()) {
                this.authServerUrl = authServerUrl;
            }
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public String getRealm() {
            return this.realm;
        }

        public String getAuthServerUrl() {
            return this.authServerUrl;
        }

        public String getSslRequired() {
            return SSL_REQUIRED;
        }

        public boolean isPublicClient() {
            return true;
        }

        public String getResource() {
            return RESOURCE;
        }
    }
}

