/*
 * Decompiled with CFR 0.152.
 */
package io.github.robwin.swagger2markup;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.robwin.markup.builder.MarkupLanguage;
import io.github.robwin.swagger2markup.builder.document.DefinitionsDocument;
import io.github.robwin.swagger2markup.builder.document.OverviewDocument;
import io.github.robwin.swagger2markup.builder.document.PathsDocument;
import io.swagger.models.Swagger;
import io.swagger.parser.SwaggerParser;
import io.swagger.util.Json;
import io.swagger.util.Yaml;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Swagger2MarkupConverter {
    private static final Logger LOG = LoggerFactory.getLogger(Swagger2MarkupConverter.class);
    private final Swagger swagger;
    private final MarkupLanguage markupLanguage;
    private final String examplesFolderPath;
    private final String schemasFolderPath;
    private final String descriptionsFolderPath;
    private final boolean separatedDefinitions;
    private static final String OVERVIEW_DOCUMENT = "overview";
    private static final String PATHS_DOCUMENT = "paths";
    private static final String DEFINITIONS_DOCUMENT = "definitions";

    Swagger2MarkupConverter(MarkupLanguage markupLanguage, Swagger swagger, String examplesFolderPath, String schemasFolderPath, String descriptionsFolderPath, boolean separatedDefinitions) {
        this.markupLanguage = markupLanguage;
        this.swagger = swagger;
        this.examplesFolderPath = examplesFolderPath;
        this.schemasFolderPath = schemasFolderPath;
        this.descriptionsFolderPath = descriptionsFolderPath;
        this.separatedDefinitions = separatedDefinitions;
    }

    public static Builder from(String swaggerLocation) {
        Validate.notEmpty((CharSequence)swaggerLocation, (String)"swaggerLocation must not be empty!", (Object[])new Object[0]);
        return new Builder(swaggerLocation);
    }

    public static Builder from(Swagger swagger) {
        Validate.notNull((Object)swagger, (String)"swagger must not be null!", (Object[])new Object[0]);
        return new Builder(swagger);
    }

    public static Builder fromString(String swagger) throws IOException {
        Validate.notEmpty((CharSequence)swagger, (String)"swagger must not be null!", (Object[])new Object[0]);
        ObjectMapper mapper = swagger.trim().startsWith("{") ? Json.mapper() : Yaml.mapper();
        JsonNode rootNode = mapper.readTree(swagger);
        JsonNode swaggerNode = rootNode.get("swagger");
        if (swaggerNode == null) {
            throw new IllegalArgumentException("Swagger String is in the wrong format");
        }
        return new Builder((Swagger)mapper.convertValue((Object)rootNode, Swagger.class));
    }

    public void intoFolder(String targetFolderPath) throws IOException {
        Validate.notEmpty((CharSequence)targetFolderPath, (String)"folderPath must not be null!", (Object[])new Object[0]);
        this.buildDocuments(targetFolderPath);
    }

    public String asString() throws IOException {
        return this.buildDocuments();
    }

    private void buildDocuments(String directory) throws IOException {
        new OverviewDocument(this.swagger, this.markupLanguage).build().writeToFile(directory, OVERVIEW_DOCUMENT, StandardCharsets.UTF_8);
        new PathsDocument(this.swagger, this.markupLanguage, this.examplesFolderPath, this.descriptionsFolderPath).build().writeToFile(directory, PATHS_DOCUMENT, StandardCharsets.UTF_8);
        new DefinitionsDocument(this.swagger, this.markupLanguage, this.schemasFolderPath, this.descriptionsFolderPath, this.separatedDefinitions, directory).build().writeToFile(directory, DEFINITIONS_DOCUMENT, StandardCharsets.UTF_8);
    }

    private String buildDocuments() throws IOException {
        return new OverviewDocument(this.swagger, this.markupLanguage).build().toString().concat(new PathsDocument(this.swagger, this.markupLanguage, this.examplesFolderPath, this.schemasFolderPath).build().toString().concat(new DefinitionsDocument(this.swagger, this.markupLanguage, this.schemasFolderPath, this.schemasFolderPath, false, null).build().toString()));
    }

    public static class Builder {
        private final Swagger swagger;
        private String examplesFolderPath;
        private String schemasFolderPath;
        private String descriptionsFolderPath;
        private boolean separatedDefinitions;
        private MarkupLanguage markupLanguage = MarkupLanguage.ASCIIDOC;

        Builder(String swaggerLocation) {
            this.swagger = new SwaggerParser().read(swaggerLocation);
            if (this.swagger == null) {
                throw new IllegalArgumentException("Failed to read the Swagger file. ");
            }
        }

        Builder(Swagger swagger) {
            this.swagger = swagger;
        }

        public Swagger2MarkupConverter build() {
            return new Swagger2MarkupConverter(this.markupLanguage, this.swagger, this.examplesFolderPath, this.schemasFolderPath, this.descriptionsFolderPath, this.separatedDefinitions);
        }

        public Builder withMarkupLanguage(MarkupLanguage markupLanguage) {
            this.markupLanguage = markupLanguage;
            return this;
        }

        public Builder withDescriptions(String descriptionsFolderPath) {
            this.descriptionsFolderPath = descriptionsFolderPath;
            return this;
        }

        public Builder withSeparatedDefinitions() {
            this.separatedDefinitions = true;
            return this;
        }

        public Builder withExamples(String examplesFolderPath) {
            this.examplesFolderPath = examplesFolderPath;
            return this;
        }

        public Builder withSchemas(String schemasFolderPath) {
            this.schemasFolderPath = schemasFolderPath;
            return this;
        }
    }
}

