/*
 * Decompiled with CFR 0.152.
 */
package io.github.talelin.core.token;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTCreator;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.TokenExpiredException;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import io.github.talelin.core.utils.DateUtil;
import java.util.Date;
import java.util.Map;

public class SingleJWT {
    private Algorithm algorithm;
    private long expire;
    private JWTVerifier verifier;
    private JWTCreator.Builder builder;

    public SingleJWT(Algorithm algorithm, long expire) {
        this.algorithm = algorithm;
        this.expire = expire;
        this.initBuilderAndVerifier();
    }

    public SingleJWT(String secret, long expire) {
        this.algorithm = Algorithm.HMAC256((String)secret);
        this.expire = expire;
        this.initBuilderAndVerifier();
    }

    public String generateToken(String tokenType, long identity, String scope, long expire) {
        Date expireDate = DateUtil.getDurationDate(expire);
        return this.builder.withClaim("type", tokenType).withClaim("identity", Long.valueOf(identity)).withClaim("scope", scope).withExpiresAt(expireDate).sign(this.algorithm);
    }

    public Map<String, Claim> decodeToken(String token) {
        DecodedJWT jwt = this.verifier.verify(token);
        this.checkTokenExpired(jwt.getExpiresAt());
        return jwt.getClaims();
    }

    private void checkTokenExpired(Date expiresAt) {
        long now = new Date().getTime();
        if (expiresAt.getTime() < now) {
            throw new TokenExpiredException("token is expired");
        }
    }

    public JWTVerifier getVerifier() {
        return this.verifier;
    }

    public JWTCreator.Builder getBuilder() {
        return this.builder;
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public Long getExpire() {
        return this.expire;
    }

    private void initBuilderAndVerifier() {
        this.verifier = JWT.require((Algorithm)this.algorithm).acceptExpiresAt(this.expire).build();
        this.builder = JWT.create();
    }
}

