/*
 * Decompiled with CFR 0.152.
 */
package io.github.talelin.core.logger;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.recovery.ResilientFileOutputStream;
import ch.qos.logback.core.util.ContextUtil;
import ch.qos.logback.core.util.FileSize;
import ch.qos.logback.core.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

public class AdvanceRollingFileAppender<E>
extends FileAppender<E> {
    File currentlyActiveFile;
    public static final long DEFAULT_BUFFER_SIZE = 8192L;
    protected boolean append = true;
    protected String fileName = null;
    private boolean prudent = false;
    private FileSize bufferSize = new FileSize(8192L);
    private String dir;
    public static final long DEFAULT_MAX_FILE_SIZE = 0xA00000L;
    FileSize maxFileSize = new FileSize(0xA00000L);

    public String getDir() {
        return this.dir;
    }

    public void setDir(String dir) {
        if (this.isAbsolute(dir)) {
            this.dir = dir;
        } else {
            String cmd = System.getProperty("user.dir");
            Path path = FileSystems.getDefault().getPath(cmd, dir);
            this.dir = path.toAbsolutePath().toString();
        }
    }

    public FileSize getMaxFileSize() {
        return this.maxFileSize;
    }

    public void setMaxFileSize(FileSize maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    public void setFile(String file) {
        if (file == null) {
            String trueFilename;
            Date now = new Date();
            String subDir = this.getPresentTime(now, "yyyy-MM");
            String filename = this.getPresentTime(now, "yyyy-MM-dd");
            this.fileName = trueFilename = String.format("%s/%s/%s.log", this.dir, subDir, filename);
        } else {
            this.fileName = file;
        }
    }

    public boolean isAppend() {
        return this.append;
    }

    public String getFile() {
        return this.fileName;
    }

    public String getPresentTime(String format) {
        Date now = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        return dateFormat.format(now);
    }

    public String getPresentTime(Date date, String format) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        return dateFormat.format(date);
    }

    public void start() {
        if (this.dir == null) {
            this.addError("log dir must be not be empty. Aborting.");
            return;
        }
        this.setFile(null);
        if (!this.append) {
            this.addWarn("Append mode is mandatory for RollingFileAppender. Defaulting to append=true.");
            this.append = true;
        }
        if (this.isPrudent() && this.rawFileProperty() != null) {
            this.addWarn("Setting \"File\" property to null on account of prudent mode");
            this.setFile(null);
        }
        this.currentlyActiveFile = new File(this.getFile());
        this.addInfo("Active log file name: " + this.getFile());
        super.start();
    }

    public void stop() {
        super.stop();
        Map map = ContextUtil.getFilenameCollisionMap((Context)this.context);
        if (map == null || this.getName() == null) {
            return;
        }
        map.remove(this.getName());
    }

    protected boolean checkForFileCollisionInPreviousFileAppenders() {
        boolean collisionsDetected = false;
        if (this.fileName == null) {
            return false;
        }
        Map map = (Map)this.context.getObject("FA_FILENAME_COLLISION_MAP");
        if (map == null) {
            return collisionsDetected;
        }
        for (Map.Entry entry : map.entrySet()) {
            if (!this.fileName.equals(entry.getValue())) continue;
            this.addErrorForCollision("File", (String)entry.getValue(), (String)entry.getKey());
            collisionsDetected = true;
        }
        if (this.name != null) {
            map.put(this.getName(), this.fileName);
        }
        return collisionsDetected;
    }

    protected void addErrorForCollision(String optionName, String optionValue, String appenderName) {
        this.addError("'" + optionName + "' option has the same value \"" + optionValue + "\" as that given for appender [" + appenderName + "] defined earlier.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openFile(String file_name) throws IOException {
        this.lock.lock();
        try {
            File file = new File(file_name);
            boolean result = FileUtil.createMissingParentDirectories((File)file);
            if (!result) {
                this.addError("Failed to create parent directories for [" + file.getAbsolutePath() + "]");
            }
            ResilientFileOutputStream resilientFos = new ResilientFileOutputStream(file, this.append, this.bufferSize.getSize());
            resilientFos.setContext(this.context);
            this.setOutputStream((OutputStream)resilientFos);
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isPrudent() {
        return this.prudent;
    }

    public void setPrudent(boolean prudent) {
        this.prudent = prudent;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public void setBufferSize(FileSize bufferSize) {
        this.addInfo("Setting bufferSize to [" + bufferSize.toString() + "]");
        this.bufferSize = bufferSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void safeWrite(E event) throws IOException {
        ResilientFileOutputStream resilientFOS = (ResilientFileOutputStream)this.getOutputStream();
        FileChannel fileChannel = resilientFOS.getChannel();
        if (fileChannel == null) {
            return;
        }
        boolean interrupted = Thread.interrupted();
        FileLock fileLock = null;
        try {
            fileLock = fileChannel.lock();
            long position = fileChannel.position();
            long size = fileChannel.size();
            if (size != position) {
                fileChannel.position(size);
            }
            super.writeOut(event);
        }
        catch (IOException e) {
            resilientFOS.postIOFailure(e);
        }
        finally {
            if (fileLock != null && fileLock.isValid()) {
                fileLock.release();
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void rollover() {
        this.lock.lock();
        try {
            this.closeOutputStream();
            this.attemptRollover();
            this.attemptOpenFile();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void attemptOpenFile() {
        try {
            this.setFile(null);
            this.currentlyActiveFile = new File(this.getFile());
            this.openFile(this.getFile());
        }
        catch (IOException e) {
            this.addError("setFile(" + this.fileName + ", false) call failed.", e);
        }
    }

    private void attemptRollover() {
        File renamedFile = this.getRenameFile();
        this.currentlyActiveFile.renameTo(renamedFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void subAppend(E event) {
        AdvanceRollingFileAppender advanceRollingFileAppender = this;
        synchronized (advanceRollingFileAppender) {
            if (this.currentlyActiveFile.length() >= this.maxFileSize.getSize()) {
                this.rollover();
            }
            if (!this.checkIsPresent()) {
                this.rollover();
            }
        }
        super.subAppend(event);
    }

    private boolean checkIsPresent() {
        this.setFile(null);
        File f = new File(this.getFile());
        return f.exists();
    }

    private File getRenameFile() {
        Date now = new Date();
        String t1 = this.getPresentTime(now, "yyyy-MM");
        String t2 = this.getPresentTime(now, "yyyy-MM-dd");
        String t3 = this.getPresentTime(now, "hh:mm:ss");
        String trueFilename = String.format("%s/%s/%s-%s.log", this.dir, t1, t2, t3);
        File file = new File(trueFilename);
        return file;
    }

    protected void append(E eventObject) {
        if (!this.isStarted()) {
            return;
        }
        this.subAppend(eventObject);
    }

    protected void writeOut(E event) throws IOException {
        if (this.prudent) {
            this.safeWrite(event);
        } else {
            super.writeOut(event);
        }
    }

    private boolean isAbsolute(String str) {
        Path path = FileSystems.getDefault().getPath(str, new String[0]);
        return path.isAbsolute();
    }
}

