/*
 * Decompiled with CFR 0.152.
 */
package io.github.talelin.core.utils;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class BeanUtil {
    private static final String SET_PREFIX = "set";
    private static final String IS_PREFIX = "is";
    private static final String GET_PREFIX = "get";

    public static PropertyDescriptor getPropertyDescriptor(Class<?> clazz, String propertyName) {
        Method setMethod = null;
        Method getMethod = null;
        PropertyDescriptor pd = null;
        try {
            Field field = clazz.getDeclaredField(propertyName);
            if (field != null) {
                String methodEnd = propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
                setMethod = clazz.getDeclaredMethod(SET_PREFIX + methodEnd, field.getType());
                getMethod = clazz.getDeclaredMethod(GET_PREFIX + methodEnd, new Class[0]);
                pd = new PropertyDescriptor(propertyName, getMethod, setMethod);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return pd;
    }

    public static PropertyDescriptor getPropertyDescriptor2(Class<?> clazz, String propertyName) {
        try {
            return new PropertyDescriptor(propertyName, clazz);
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void setProperty(Object obj, String propertyName, Object value) {
        Class<?> clazz = obj.getClass();
        PropertyDescriptor pd = BeanUtil.getPropertyDescriptor(clazz, propertyName);
        Method setMethod = pd.getWriteMethod();
        try {
            setMethod.invoke(obj, value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getProperty(Object obj, String propertyName) {
        Class<?> clazz = obj.getClass();
        String value = null;
        try {
            PropertyDescriptor pd = BeanUtil.getPropertyDescriptor(clazz, propertyName);
            Method getMethod = pd.getReadMethod();
            value = getMethod.invoke(clazz, new Object[0]).toString();
        }
        catch (Exception e) {
            return "";
        }
        return value;
    }

    public static String getValueByPropName(Object obj, String propName) {
        String value;
        Class<?> clazz = obj.getClass();
        try {
            String upperCaseFirstOne = BeanUtil.toUpperCaseFirstOne(propName);
            Method method = clazz.getMethod(GET_PREFIX + upperCaseFirstOne, new Class[0]);
            Object result = method.invoke(obj, new Object[0]);
            value = result.toString();
        }
        catch (Exception e) {
            return "";
        }
        return value;
    }

    public static String toUpperCaseFirstOne(String s) {
        if (Character.isUpperCase(s.charAt(0))) {
            return s;
        }
        return Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }
}

