package io.github.xinyangpan.wechat4j.api;

import org.apache.commons.codec.digest.DigestUtils;

import io.github.xinyangpan.wechat4j.core.dto.WxConfig;
import io.github.xinyangpan.wechat4j.core.dto.json.AccessToken;
import io.github.xinyangpan.wechat4j.core.dto.json.JsapiTicket;
import okhttp3.HttpUrl;

public class CoreApi extends AbstractApi {
	// 
	private AccessToken accessToken;
	private JsapiTicket jsapiTicket;

	public WxConfig generateWxConfig(String url) {
		String jsapiTicket = this.currentJsapiTicket();
		String appId = this.wechatExtProperties.getAppId();
		WxConfig wxConfig = new WxConfig(appId);
		// generate signature
		String signature = DigestUtils.sha1Hex(String.format("jsapi_ticket=%s&noncestr=%s&timestamp=%s&url=%s", jsapiTicket, wxConfig.getNonceStr(), wxConfig.getTimestamp(), url));
		wxConfig.setSignature(signature);
		return wxConfig;
	}

	public synchronized String currentJsapiTicket() {
		if (jsapiTicket == null || jsapiTicket.isExpired()) {
			this.jsapiTicket = this.jsapiTicket(this.currentAccessToken());
		}
		return jsapiTicket.getTicket();
	}

	public synchronized String currentAccessToken() {
		if (accessToken == null || accessToken.isExpired()) {
			this.accessToken = this.accessToken(wechatExtProperties.getAppId(), wechatExtProperties.getAppSecret());
		}
		return accessToken.getAccessToken();
	}

	// ticket/getticket?access_token=ACCESS_TOKEN&type=jsapi
	private JsapiTicket jsapiTicket(String accessToken) {
		HttpUrl url = wechatExtService.commonBuilder()//
			.addPathSegment("ticket")//
			.addPathSegment("getticket")//
			.addQueryParameter("access_token", accessToken)//
			.addQueryParameter("type", "jsapi")//
			.build();
		JsapiTicket jsapiTicket = restTemplate.getForObject(url.toString(), JsapiTicket.class);
		return jsapiTicket.throwExceptionIfError();
	}

	private AccessToken accessToken(String appId, String appSecret) {
		HttpUrl url = wechatExtService.commonBuilder()//
			.addPathSegment("token")//
			.addQueryParameter("grant_type", "client_credential")//
			.addQueryParameter("appid", appId)//
			.addQueryParameter("secret", appSecret)//
			.build();
		AccessToken accessToken = restTemplate.getForObject(url.toString(), AccessToken.class);
		return accessToken.throwExceptionIfError();
	}

}
