package io.github.xinyangpan.wechat4j.api;

import io.github.xinyangpan.wechat4j.core.dto.json.MsgRecordRequest;
import io.github.xinyangpan.wechat4j.core.dto.json.MsgRecordResult;
import okhttp3.HttpUrl;

public class CustomerServiceApi extends AbstractBusinessApi {

	public <T> MsgRecordResult getMessageRecord(MsgRecordRequest msgRecordRequest) {
		HttpUrl url = wechatExtService.csBuilder()//
			.addPathSegment("msgrecord")//
			.addPathSegment("getmsglist")//
			.addQueryParameter("access_token", coreApi.currentAccessToken())//
			.build();
		MsgRecordResult msgRecordResult = restTemplate.postForObject(url.toString(), msgRecordRequest, MsgRecordResult.class);
		return msgRecordResult.throwExceptionIfError();
	}

}
