package io.github.xinyangpan.wechat4j.api;

import io.github.xinyangpan.wechat4j.core.dto.json.ApiError;
import io.github.xinyangpan.wechat4j.core.dto.json.CustomMessage;
import io.github.xinyangpan.wechat4j.core.dto.json.TemplateMessage;
import okhttp3.HttpUrl;

public class MessageApi extends AbstractBusinessApi {

	public <T> ApiError sendTemplateMessage(TemplateMessage<T> templateMessage) {
		HttpUrl url = wechatExtService.commonBuilder()//
			.addPathSegment("message")//
			.addPathSegment("template")//
			.addPathSegment("send")//
			.addQueryParameter("access_token", coreApi.currentAccessToken())//
			.build();
		// 
		ApiError apiError = restTemplate.postForObject(url.toString(), templateMessage, ApiError.class);
		return apiError.throwExceptionIfError();
	}

	public <T> ApiError sendCustomMessage(String openId, String content) {
		HttpUrl url = wechatExtService.commonBuilder()//
			.addPathSegment("message")//
			.addPathSegment("custom")//
			.addPathSegment("send")//
			.addQueryParameter("access_token", coreApi.currentAccessToken())//
			.build();
		// 
		CustomMessage textMessage = CustomMessage.textMessage(openId, content);
		ApiError apiError = restTemplate.postForObject(url.toString(), textMessage, ApiError.class);
		return apiError.throwExceptionIfError();
	}

}
