package io.github.xinyangpan.wechat4j.api;

import java.io.IOException;

import com.fasterxml.jackson.dataformat.xml.XmlMapper;

import io.github.xinyangpan.wechat4j.core.CoreUtils;
import io.github.xinyangpan.wechat4j.core.dto.xml.pay.UnifiedOrder;
import io.github.xinyangpan.wechat4j.core.dto.xml.pay.UnifiedOrderResult;
import okhttp3.HttpUrl;

public class PayApi extends AbstractBusinessApi {
	private final XmlMapper xmlMapper;

	public PayApi() {
		this(CoreUtils.defaultXmlMapper());
	}

	public PayApi(XmlMapper xmlMapper) {
		this.xmlMapper = xmlMapper;
	}

	public UnifiedOrderResult unifiedOrder(UnifiedOrder unifiedOrder) {
		try {
			unifiedOrder = wechatExtService.sign(unifiedOrder);
			HttpUrl url = wechatExtService.payBuilder()//
				.addPathSegment("unifiedorder")//
				.build();
			// 
			String unifiedOrderXml = xmlMapper.writeValueAsString(unifiedOrder);
			String unifiedOrderResultXml = restTemplate.postForObject(url.toString(), unifiedOrderXml, String.class);
			unifiedOrderResultXml = CoreUtils.utf8ConvertIn(unifiedOrderResultXml);
			log.info("Result Xml: {}", unifiedOrderResultXml);
			UnifiedOrderResult unifiedOrderResult = xmlMapper.readValue(unifiedOrderResultXml, UnifiedOrderResult.class);
			return wechatExtService.checkSign(unifiedOrderResult);
		} catch (IOException e) {
			log.error("error for {}.", unifiedOrder, e);
			throw new RuntimeException(e);
		}
	}

}
