package io.github.xinyangpan.wechat4j.api;

import io.github.xinyangpan.wechat4j.core.dto.json.QrCode;
import io.github.xinyangpan.wechat4j.core.dto.json.QrCodeResult;
import okhttp3.HttpUrl;

public class QrCodeApi extends AbstractBusinessApi {

	public QrCodeResult create(QrCode qrCode) {
		HttpUrl url = wechatExtService.commonBuilder()//
			.addPathSegment("qrcode")//
			.addPathSegment("create")//
			.addQueryParameter("access_token", coreApi.currentAccessToken())//
			.build();
		// 
		QrCodeResult qrCodeResult = restTemplate.postForObject(url.toString(), qrCode, QrCodeResult.class);
		return qrCodeResult.throwExceptionIfError();
	}

}
