package io.github.xinyangpan.wechat4j.api;

import io.github.xinyangpan.wechat4j.core.dto.json.UserInfo;
import okhttp3.HttpUrl;

public class UserApi extends AbstractBusinessApi {

	public <T> UserInfo getUserInfo(String openId) {
		HttpUrl url = wechatExtService.commonBuilder()//
			.addPathSegment("user")//
			.addPathSegment("info")//
			.addQueryParameter("access_token", coreApi.currentAccessToken())//
			.addQueryParameter("openid", openId)//
			.build();
		// 
		UserInfo apiError = restTemplate.getForObject(url.toString(), UserInfo.class);
		return apiError.throwExceptionIfError();
	}

}
