package io.github.xinyangpan.wechat4j.core;

import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties("wechat")
public class WechatExtProperties {

	private String appId;
	private String appSecret;
	private String token;
	private String redirectUri;
	private String oauthState;
	// WeChat Pay
	private String mchId;
	private String payNotifyUrl;
	private String payKey;

	@Override
	public String toString() {
		return String.format("WechatExtProperties [appId=%s, appSecret=%s, token=%s, redirectUri=%s, oauthState=%s, mchId=%s, payNotifyUrl=%s, payKey=%s]", appId, appSecret, token, redirectUri, oauthState, mchId, payNotifyUrl, payKey);
	}

	public String getAppId() {
		return appId;
	}

	public void setAppId(String appId) {
		this.appId = appId;
	}

	public String getAppSecret() {
		return appSecret;
	}

	public void setAppSecret(String appSecret) {
		this.appSecret = appSecret;
	}

	public String getToken() {
		return token;
	}

	public void setToken(String token) {
		this.token = token;
	}

	public String getRedirectUri() {
		return redirectUri;
	}

	public void setRedirectUri(String redirectUri) {
		this.redirectUri = redirectUri;
	}

	public String getOauthState() {
		return oauthState;
	}

	public void setOauthState(String oauthState) {
		this.oauthState = oauthState;
	}

	public String getMchId() {
		return mchId;
	}

	public void setMchId(String mchId) {
		this.mchId = mchId;
	}

	public String getPayNotifyUrl() {
		return payNotifyUrl;
	}

	public void setPayNotifyUrl(String payNotifyUrl) {
		this.payNotifyUrl = payNotifyUrl;
	}

	public String getPayKey() {
		return payKey;
	}

	public void setPayKey(String payKey) {
		this.payKey = payKey;
	}

}