package io.github.xinyangpan.wechat4j.core.dto;

import io.github.xinyangpan.wechat4j.core.CoreUtils;

public class BaseInfo {
	//	公众号id	appId	是	String(16)	wx8888888888888888	商户注册具有支付权限的公众号成功后即可获得
	protected String appId;
	//	时间戳	timeStamp	是	String(32)	1414561699	当前的时间，其他详见时间戳规则
	protected final String timestamp;
	//	随机字符串	nonceStr	是	String(32)	5K8264ILTKCH16CQ2502SI8ZNMTM67VS	随机字符串，不长于32位。推荐随机数生成算法
	protected final String nonceStr;
	
	public BaseInfo() {
		long ts = System.currentTimeMillis()/1000;
		timestamp = String.valueOf(ts);
		nonceStr = CoreUtils.nextNonceString();
	}
	
	public BaseInfo(String appId) {
		this();
		this.appId = appId;
	}

	@Override
	public String toString() {
		return String.format("AbstractInfo [appId=%s, timestamp=%s, nonceStr=%s]", appId, timestamp, nonceStr);
	}

	public String getAppId() {
		return appId;
	}

	public void setAppId(String appId) {
		this.appId = appId;
	}

	public String getTimestamp() {
		return timestamp;
	}

	public String getNonceStr() {
		return nonceStr;
	}

}
