package io.github.xinyangpan.wechat4j.core.dto;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.Lists;

import io.github.xinyangpan.wechat4j.core.pay.HasSign;

public class PayInfo extends BaseInfo implements HasSign {
	//	订单详情扩展字符串	package	是	String(128)	prepay_id=123456789	统一下单接口返回的prepay_id参数值，提交格式如：prepay_id=***
	private String package_;
	//	签名方式	signType	是	String(32)	MD5	签名类型，默认为MD5，支持HMAC-SHA256和MD5。注意此处需与统一下单的签名类型一致
	private String signType = "MD5";
	//	签名	paySign	是	String(64)	C380BEC2BFD727A4B6845133519F3AD6	签名，详见签名生成算法
	private String paySign;
	// prepay id 不参与签名
	private String prepayId;

	public PayInfo() {
	}

	public PayInfo(String appId) {
		super(appId);
	}

	public String getTimeStamp() {
		return super.getTimestamp();
	}

	@JsonIgnore
	@Override
	public String getTimestamp() {
		return super.getTimestamp();
	}

	public void setPrepayId(String prepayId) {
		this.prepayId = prepayId;
		package_ = String.format("prepay_id=%s", prepayId);
	}

	@Override
	public List<String> removeKeys() {
		return Lists.newArrayList("paySign", "timestamp", "prepayId");
	}

	@JsonIgnore
	@Override
	public void setSign(String sign) {
		this.setPaySign(sign);
	}

	@JsonIgnore
	@Override
	public String getSign() {
		return this.getPaySign();
	}

	// -----------------------------
	// ----- Get Set ToString HashCode Equals
	// -----------------------------

	@Override
	public String toString() {
		return String.format("PayInfo [appId=%s, timeStamp=%s, nonceStr=%s, package=%s, signType=%s, paySign=%s]", appId, timestamp, nonceStr, package_, signType, paySign);
	}

	public String getPackage() {
		return package_;
	}

	public void setPackage(String package_) {
		this.package_ = package_;
	}

	public String getSignType() {
		return signType;
	}

	public void setSignType(String signType) {
		this.signType = signType;
	}

	public String getPaySign() {
		return paySign;
	}

	public void setPaySign(String paySign) {
		this.paySign = paySign;
	}

	public String getPrepayId() {
		return prepayId;
	}

}
