package io.github.xinyangpan.wechat4j.core.dto.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;

import io.github.xinyangpan.wechat4j.core.dto.json.enums.MsgType;

@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
@JsonInclude(Include.NON_NULL)
public class CustomMessage {
	private String touser;
	private MsgType msgtype;
	private Text text;

	public static CustomMessage textMessage(String touser, String content) {
		CustomMessage textMessage = new CustomMessage();
		textMessage.setTouser(touser);
		textMessage.setMsgtype(MsgType.text);
		textMessage.setText(new Text(content));
		return textMessage;
	}

	@Override
	public String toString() {
		return String.format("CustomMessage [touser=%s, msgtype=%s, text=%s]", touser, msgtype, text);
	}

	public String getTouser() {
		return touser;
	}

	public void setTouser(String touser) {
		this.touser = touser;
	}

	public MsgType getMsgtype() {
		return msgtype;
	}

	public void setMsgtype(MsgType msgtype) {
		this.msgtype = msgtype;
	}

	public Text getText() {
		return text;
	}

	public void setText(Text text) {
		this.text = text;
	}

}
