package io.github.xinyangpan.wechat4j.core.dto.json;

import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.google.common.base.Preconditions;

@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
public class Scene {
	private long sceneId;

	@Override
	public String toString() {
		return String.format("Scene [sceneId=%s]", getSceneId());
	}

	public long getSceneId() {
		return sceneId;
	}

	public void setSceneId(long sceneId) {
		Preconditions.checkArgument(sceneId >= 1);
		Preconditions.checkArgument(sceneId <= 100000);
		this.sceneId = sceneId;
	}

}
