package io.github.xinyangpan.wechat4j.core.dto.json;

public abstract class Token extends ApiError {
	protected long createTimestamp = System.currentTimeMillis();
	protected int expiresIn;

	public boolean isExpired() {
		long now = System.currentTimeMillis();
		if (now > createTimestamp + expiresIn * 1000) {
			return true;
		} else {
			return false;
		}
	}

	@Override
	public String toString() {
		return String.format("Token [createTimestamp=%s, expiresIn=%s, errcode=%s, errmsg=%s]", createTimestamp, expiresIn, errcode, errmsg);
	}

	public int getExpiresIn() {
		return expiresIn;
	}

	public void setExpiresIn(int expiresIn) {
		this.expiresIn = expiresIn;
	}

}
