package io.github.xinyangpan.wechat4j.core.dto.xml.pay;

import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import org.springframework.util.Assert;

import com.google.common.collect.Lists;

public class Coupon {

	// 代金券ID	coupon_id_$n	否	String(20)	10000 
	private String couponId;
	// 代金券类型	coupon_type_$n	否	String	CASH
	private String couponType;
	// 单个代金券支付金额	coupon_fee_$n	否	Int	100
	private int couponFee;

	public static List<Coupon> getCoupons(Map<String, Object> map) {
		List<Coupon> coupons = Lists.newArrayList();
		for (Entry<String, Object> e : map.entrySet()) {
			String name = e.getKey();
			String value = (String)e.getValue();
			String[] split = name.split("_");
			Assert.state(split.length == 3, String.format("length error. name=%s, value=%s", name, value));
			String fieldName = split[1];
			int index = Integer.parseInt(split[2]);
			Coupon coupon;
			if (coupons.size() <= index) {
				coupon = new Coupon();
				coupons.add(coupon);
			} else {
				coupon = coupons.get(index);
			}
			switch (fieldName) {
			case "id":
				coupon.setCouponId((String)value);
				break;
			case "type":
				coupon.setCouponType(value);
				break;
			case "fee":
				coupon.setCouponFee(Integer.parseInt(value));
				break;
			default:
				throw new UnsupportedOperationException(String.format("field name error. name=%s, value=%s", name, value));
			}
		}
		return coupons;
	}

	// -----------------------------
	// ----- Get Set ToString HashCode Equals
	// -----------------------------

	@Override
	public String toString() {
		return String.format("Coupon [couponId=%s, couponType=%s, couponFee=%s]", couponId, couponType, couponFee);
	}

	public String getCouponId() {
		return couponId;
	}

	public void setCouponId(String couponId) {
		this.couponId = couponId;
	}

	public String getCouponType() {
		return couponType;
	}

	public void setCouponType(String couponType) {
		this.couponType = couponType;
	}

	public int getCouponFee() {
		return couponFee;
	}

	public void setCouponFee(int couponFee) {
		this.couponFee = couponFee;
	}

}
