package io.github.xinyangpan.wechat4j.core.dto.xml.pay;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;

import io.github.xinyangpan.wechat4j.core.pay.HasSign;

@JsonInclude(Include.NON_NULL)
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
public class OrderQueryResult implements HasSign {
	// 返回状态码	return_code	是	String(16)	SUCCESS
	private String returnCode;
	// 返回信息	return_msg	是	String(128)	OK
	private String returnMsg;

	// 以下字段在return_code为SUCCESS的时候有返回
	// 公众账号ID	appid	是	String(32)	wx8888888888888888	调用接口提交的公众账号ID
	private String appid;
	// 商户号	mch_id	是	String(32)	1900000109	调用接口提交的商户号
	private String mchId;
	// 随机字符串	nonce_str	是	String(32)	5K8264ILTKCH16CQ2502SI8ZNMTM67VS
	private String nonceStr;
	// 签名	sign	是	String(32)	C380BEC2BFD727A4B6845133519F3AD6
	private String sign;
	// 业务结果	result_code	是	String(16)	SUCCESS
	private String resultCode;
	// 错误代码	err_code	否	String(32)
	private String errCode;
	// 错误代码描述	err_code_des	否	String(128)	
	private String errCodeDes;

	// 以下字段在return_code 、result_code、trade_state都为SUCCESS时有返回 ，如trade_state不为 SUCCESS，则只返回out_trade_no（必传）和attach（选传）。
	// 设备号	device_info	否	String(32)	013467007045764
	private String deviceInfo;
	// 用户标识	openid	否	String(128)	oUpF8uMuAJO_M2pxb1Q9zNjWeS6o
	private String openid;
	// 是否关注公众账号	is_subscribe	否	String(1)	Y	用户是否关注公众账号，Y-关注，N-未关注，仅在公众账号类型支付有效
	private String isSubscribe;
	// 交易类型	trade_type	是	String(16)	JSAPI
	private String tradeType;
	// 交易状态	trade_state	是	String(32)	SUCCESS
	private String tradeState;
	// 付款银行	bank_type	是	String(16)	CMC
	private String bankType;
	// 标价金额	total_fee	是	Int	100
	private Integer totalFee;
	// 应结订单金额	settlement_total_fee	否	Int	100
	private Integer settlementTotalFee;
	// 标价币种	fee_type	否	String(8)	CNY
	private String feeType;
	// 现金支付金额	cash_fee	是	Int	100
	private Integer cashFee;
	// 现金支付币种	cash_fee_type	否	String(16)	CNY
	private String cashFeeType;
	// 代金券金额	coupon_fee	否	Int	100
	private Integer couponFee;
	// 代金券使用数量	coupon_count	否	Int	1
	private Integer couponCount;
	// 微信支付订单号	transaction_id	是	String(32)	1009660380201506130728806387
	private String transactionId;
	// 商户订单号	out_trade_no	是	String(32)	20150806125346
	private String outTradeNo;
	// 附加数据	attach	否	String(128)	深圳分店
	private String attach;
	// 支付完成时间	time_end	是	String(14)	20141030133525
	private String timeEnd;
	// 交易状态描述	trade_state_desc	是	String(256)	支付失败，请重新下单支付
	private String tradeStateDesc;
	// 代金券 动态字段
	@JsonIgnore
	private Map<String, Object> additionalProperties = new HashMap<String, Object>();

	public List<Coupon> coupons() {
		return Coupon.getCoupons(additionalProperties);
	}

	@JsonAnyGetter
	public Map<String, Object> getAdditionalProperties() {
		return this.additionalProperties;
	}

	@JsonAnySetter
	public void setAdditionalProperty(String name, Object value) {
		this.additionalProperties.put(name, value);
	}

	@Override
	public String toString() {
		return String.format("OrderQueryResult [returnCode=%s, returnMsg=%s, appid=%s, mchId=%s, nonceStr=%s, sign=%s, resultCode=%s, errCode=%s, errCodeDes=%s, deviceInfo=%s, openid=%s, isSubscribe=%s, tradeType=%s, tradeState=%s, bankType=%s, totalFee=%s, settlementTotalFee=%s, feeType=%s, cashFee=%s, cashFeeType=%s, couponFee=%s, couponCount=%s, transactionId=%s, outTradeNo=%s, attach=%s, timeEnd=%s, tradeStateDesc=%s, additionalProperties=%s]", returnCode, returnMsg, appid, mchId, nonceStr, sign, resultCode, errCode, errCodeDes, deviceInfo, openid, isSubscribe, tradeType, tradeState, bankType, totalFee, settlementTotalFee, feeType, cashFee, cashFeeType, couponFee, couponCount, transactionId, outTradeNo, attach, timeEnd, tradeStateDesc, additionalProperties);
	}

	public String getReturnCode() {
		return returnCode;
	}

	public void setReturnCode(String returnCode) {
		this.returnCode = returnCode;
	}

	public String getReturnMsg() {
		return returnMsg;
	}

	public void setReturnMsg(String returnMsg) {
		this.returnMsg = returnMsg;
	}

	public String getAppid() {
		return appid;
	}

	public void setAppid(String appid) {
		this.appid = appid;
	}

	public String getMchId() {
		return mchId;
	}

	public void setMchId(String mchId) {
		this.mchId = mchId;
	}

	public String getNonceStr() {
		return nonceStr;
	}

	public void setNonceStr(String nonceStr) {
		this.nonceStr = nonceStr;
	}

	public String getSign() {
		return sign;
	}

	public void setSign(String sign) {
		this.sign = sign;
	}

	public String getResultCode() {
		return resultCode;
	}

	public void setResultCode(String resultCode) {
		this.resultCode = resultCode;
	}

	public String getErrCode() {
		return errCode;
	}

	public void setErrCode(String errCode) {
		this.errCode = errCode;
	}

	public String getErrCodeDes() {
		return errCodeDes;
	}

	public void setErrCodeDes(String errCodeDes) {
		this.errCodeDes = errCodeDes;
	}

	public String getDeviceInfo() {
		return deviceInfo;
	}

	public void setDeviceInfo(String deviceInfo) {
		this.deviceInfo = deviceInfo;
	}

	public String getOpenid() {
		return openid;
	}

	public void setOpenid(String openid) {
		this.openid = openid;
	}

	public String getIsSubscribe() {
		return isSubscribe;
	}

	public void setIsSubscribe(String isSubscribe) {
		this.isSubscribe = isSubscribe;
	}

	public String getTradeType() {
		return tradeType;
	}

	public void setTradeType(String tradeType) {
		this.tradeType = tradeType;
	}

	public String getTradeState() {
		return tradeState;
	}

	public void setTradeState(String tradeState) {
		this.tradeState = tradeState;
	}

	public String getBankType() {
		return bankType;
	}

	public void setBankType(String bankType) {
		this.bankType = bankType;
	}

	public Integer getTotalFee() {
		return totalFee;
	}

	public void setTotalFee(Integer totalFee) {
		this.totalFee = totalFee;
	}

	public Integer getSettlementTotalFee() {
		return settlementTotalFee;
	}

	public void setSettlementTotalFee(Integer settlementTotalFee) {
		this.settlementTotalFee = settlementTotalFee;
	}

	public String getFeeType() {
		return feeType;
	}

	public void setFeeType(String feeType) {
		this.feeType = feeType;
	}

	public Integer getCashFee() {
		return cashFee;
	}

	public void setCashFee(Integer cashFee) {
		this.cashFee = cashFee;
	}

	public String getCashFeeType() {
		return cashFeeType;
	}

	public void setCashFeeType(String cashFeeType) {
		this.cashFeeType = cashFeeType;
	}

	public Integer getCouponFee() {
		return couponFee;
	}

	public void setCouponFee(Integer couponFee) {
		this.couponFee = couponFee;
	}

	public Integer getCouponCount() {
		return couponCount;
	}

	public void setCouponCount(Integer couponCount) {
		this.couponCount = couponCount;
	}

	public String getTransactionId() {
		return transactionId;
	}

	public void setTransactionId(String transactionId) {
		this.transactionId = transactionId;
	}

	public String getOutTradeNo() {
		return outTradeNo;
	}

	public void setOutTradeNo(String outTradeNo) {
		this.outTradeNo = outTradeNo;
	}

	public String getAttach() {
		return attach;
	}

	public void setAttach(String attach) {
		this.attach = attach;
	}

	public String getTimeEnd() {
		return timeEnd;
	}

	public void setTimeEnd(String timeEnd) {
		this.timeEnd = timeEnd;
	}

	public String getTradeStateDesc() {
		return tradeStateDesc;
	}

	public void setTradeStateDesc(String tradeStateDesc) {
		this.tradeStateDesc = tradeStateDesc;
	}

}
