package io.github.xinyangpan.wechat4j.core.dto.xml.pay;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;

import io.github.xinyangpan.wechat4j.core.pay.HasSign;

@JsonInclude(Include.NON_NULL)
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
@JacksonXmlRootElement(localName = "xml")
public class PayCallbackInfo implements HasSign {
	// 返回状态码	return_code	是	String(16)	SUCCESS
	private String returnCode;
	// 返回信息	return_msg	是	String(128)	OK
	private String returnMsg;
	// 公众账号ID	appid	是	String(32)	wx8888888888888888
	private String appid;
	// 商户号	mch_id	是	String(32)	1900000109
	private String mchId;
	// 设备号	device_info	否	String(32)	013467007045764
	private String deviceInfo;
	// 随机字符串	nonce_str	是	String(32)	5K8264ILTKCH16CQ2502SI8ZNMTM67VS
	private String nonceStr;
	// 签名	sign	是	String(32)	C380BEC2BFD727A4B6845133519F3AD6
	private String sign;
	// 签名类型	sign_type	否	String(32)	HMAC-SHA256
	private String signType;
	// 业务结果	result_code	是	String(16)	SUCCESS
	private String resultCode;
	// 错误代码	err_code	否	String(32)	SYSTEMERROR
	private String errCode;
	// 错误代码描述	err_code_des	否	String(128)	系统错误
	private String errCodeDes;
	// 用户标识	openid	是	String(128)	wxd930ea5d5a258f4f
	private String openid;
	// 是否关注公众账号	is_subscribe	否	String(1)	Y
	private String isSubscribe;
	// 交易类型	trade_type	是	String(16)	JSAPI
	private String tradeType;
	// 付款银行	bank_type	是	String(16)	CMC
	private String bankType;
	// 订单金额	total_fee	是	Int	100
	private Integer totalFee;
	// 应结订单金额	settlement_total_fee	否	Int	100
	private Integer settlementTotalFee;
	// 货币种类	fee_type	否	String(8)	CNY
	private String feeType;
	// 现金支付金额	cash_fee	是	Int	100
	private String cashFee;
	// 现金支付货币类型	cash_fee_type	否	String(16)	CNY
	private String cashFeeType;
	// 总代金券金额	coupon_fee	否	Int	10
	private String couponFee;
	// 代金券使用数量	coupon_count	否	Int	1
	private String couponCount;
	// 微信支付订单号	transaction_id	是	String(32)	1217752501201407033233368018
	private String transactionId;
	// 商户订单号	out_trade_no	是	String(32)	1212321211201407033568112322
	private String outTradeNo;
	// 商家数据包	attach	否	String(128)	123456
	private String attach;
	// 支付完成时间	time_end	是	String(14)	20141030133525
	private String timeEnd;
	// 代金券 动态字段
	@JsonIgnore
	private Map<String, Object> additionalProperties = new HashMap<String, Object>();

	public List<Coupon> coupons() {
		return Coupon.getCoupons(additionalProperties);
	}

	public boolean successfullPayed() {
		if (!Objects.equals(returnCode, "SUCCESS")) {
			return false;
		}
		if (!Objects.equals(resultCode, "SUCCESS")) {
			return false;
		}
		if (totalFee <= 0) {
			return false;
		}
		return true;
	}

	@JsonAnyGetter
	public Map<String, Object> getAdditionalProperties() {
		return this.additionalProperties;
	}

	@JsonAnySetter
	public void setAdditionalProperty(String name, Object value) {
		this.additionalProperties.put(name, value);
	}

	// -----------------------------
	// ----- Get Set ToString HashCode Equals
	// -----------------------------

	@Override
	public String toString() {
		return String.format("PayCallbackInfo [returnCode=%s, returnMsg=%s, appid=%s, mchId=%s, deviceInfo=%s, nonceStr=%s, sign=%s, signType=%s, resultCode=%s, errCode=%s, errCodeDes=%s, openid=%s, isSubscribe=%s, tradeType=%s, bankType=%s, totalFee=%s, settlementTotalFee=%s, feeType=%s, cashFee=%s, cashFeeType=%s, couponFee=%s, couponCount=%s, transactionId=%s, outTradeNo=%s, attach=%s, timeEnd=%s, additionalProperties=%s]", returnCode, returnMsg, appid, mchId, deviceInfo, nonceStr, sign, signType, resultCode, errCode, errCodeDes, openid, isSubscribe, tradeType, bankType, totalFee, settlementTotalFee, feeType, cashFee, cashFeeType, couponFee, couponCount, transactionId, outTradeNo, attach, timeEnd, additionalProperties);
	}

	public String getReturnCode() {
		return returnCode;
	}

	public void setReturnCode(String returnCode) {
		this.returnCode = returnCode;
	}

	public String getReturnMsg() {
		return returnMsg;
	}

	public void setReturnMsg(String returnMsg) {
		this.returnMsg = returnMsg;
	}

	public String getAppid() {
		return appid;
	}

	public void setAppid(String appid) {
		this.appid = appid;
	}

	public String getMchId() {
		return mchId;
	}

	public void setMchId(String mchId) {
		this.mchId = mchId;
	}

	public String getDeviceInfo() {
		return deviceInfo;
	}

	public void setDeviceInfo(String deviceInfo) {
		this.deviceInfo = deviceInfo;
	}

	public String getNonceStr() {
		return nonceStr;
	}

	public void setNonceStr(String nonceStr) {
		this.nonceStr = nonceStr;
	}

	public String getSign() {
		return sign;
	}

	public void setSign(String sign) {
		this.sign = sign;
	}

	public String getSignType() {
		return signType;
	}

	public void setSignType(String signType) {
		this.signType = signType;
	}

	public String getResultCode() {
		return resultCode;
	}

	public void setResultCode(String resultCode) {
		this.resultCode = resultCode;
	}

	public String getErrCode() {
		return errCode;
	}

	public void setErrCode(String errCode) {
		this.errCode = errCode;
	}

	public String getErrCodeDes() {
		return errCodeDes;
	}

	public void setErrCodeDes(String errCodeDes) {
		this.errCodeDes = errCodeDes;
	}

	public String getOpenid() {
		return openid;
	}

	public void setOpenid(String openid) {
		this.openid = openid;
	}

	public String getIsSubscribe() {
		return isSubscribe;
	}

	public void setIsSubscribe(String isSubscribe) {
		this.isSubscribe = isSubscribe;
	}

	public String getTradeType() {
		return tradeType;
	}

	public void setTradeType(String tradeType) {
		this.tradeType = tradeType;
	}

	public String getBankType() {
		return bankType;
	}

	public void setBankType(String bankType) {
		this.bankType = bankType;
	}

	public Integer getTotalFee() {
		return totalFee;
	}

	public void setTotalFee(Integer totalFee) {
		this.totalFee = totalFee;
	}

	public Integer getSettlementTotalFee() {
		return settlementTotalFee;
	}

	public void setSettlementTotalFee(Integer settlementTotalFee) {
		this.settlementTotalFee = settlementTotalFee;
	}

	public String getFeeType() {
		return feeType;
	}

	public void setFeeType(String feeType) {
		this.feeType = feeType;
	}

	public String getCashFee() {
		return cashFee;
	}

	public void setCashFee(String cashFee) {
		this.cashFee = cashFee;
	}

	public String getCashFeeType() {
		return cashFeeType;
	}

	public void setCashFeeType(String cashFeeType) {
		this.cashFeeType = cashFeeType;
	}

	public String getCouponFee() {
		return couponFee;
	}

	public void setCouponFee(String couponFee) {
		this.couponFee = couponFee;
	}

	public String getCouponCount() {
		return couponCount;
	}

	public void setCouponCount(String couponCount) {
		this.couponCount = couponCount;
	}

	public String getTransactionId() {
		return transactionId;
	}

	public void setTransactionId(String transactionId) {
		this.transactionId = transactionId;
	}

	public String getOutTradeNo() {
		return outTradeNo;
	}

	public void setOutTradeNo(String outTradeNo) {
		this.outTradeNo = outTradeNo;
	}

	public String getAttach() {
		return attach;
	}

	public void setAttach(String attach) {
		this.attach = attach;
	}

	public String getTimeEnd() {
		return timeEnd;
	}

	public void setTimeEnd(String timeEnd) {
		this.timeEnd = timeEnd;
	}

}
