package io.github.xinyangpan.wechat4j.core.dto.xml.pay;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;

@JsonInclude(Include.NON_NULL)
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
@JacksonXmlRootElement(localName = "xml")
public class PayCallbackResult {
	public static PayCallbackResult SUCCESS = new PayCallbackResult("SUCCESS", "OK");
	// 返回状态码	return_code	是	String(16)	SUCCESS
	private String returnCode;
	// 返回信息	return_msg	否	String(128)	OK
	private String returnMsg;

	public PayCallbackResult() {
	}

	public PayCallbackResult(String returnCode, String returnMsg) {
		super();
		this.returnCode = returnCode;
		this.returnMsg = returnMsg;
	}

	@Override
	public String toString() {
		return String.format("PayCallbackResult [returnCode=%s, returnMsg=%s]", returnCode, returnMsg);
	}

	public String getReturnCode() {
		return returnCode;
	}

	public void setReturnCode(String returnCode) {
		this.returnCode = returnCode;
	}

	public String getReturnMsg() {
		return returnMsg;
	}

	public void setReturnMsg(String returnMsg) {
		this.returnMsg = returnMsg;
	}

}
