package io.github.xinyangpan.wechat4j.core.dto.xml.pay;

//场景信息	scene_info	否	String(256)	
//{"store_info" : {
//"id": "SZTX001",
//"name": "腾大餐厅",
//"area_code": "440305",
//"address": "科技园中一路腾讯大厦" }}
//
//该字段用于上报场景信息，目前支持上报实际门店信息。该字段为JSON对象数据，对象格式为{"store_info":{"id": "门店ID","name": "名称","area_code": "编码","address": "地址" }} ，字段详细说明请点击行前的+展开
public class SceneInfo {

	// -门店id	id	否	String(32)	SZTX001
	private String id;
	// -门店名称	name	否	String(64)	腾讯大厦腾大餐厅
	private String name;
	// -门店行政区划码	area_code	否	String(6)	440305
	private String areaCode;
	// -门店详细地址	address	否	String(128)	科技园中一路腾讯大厦	
	private String address;

	@Override
	public String toString() {
		return String.format("SceneInfo [id=%s, name=%s, areaCode=%s, address=%s]", id, name, areaCode, address);
	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getAreaCode() {
		return areaCode;
	}

	public void setAreaCode(String areaCode) {
		this.areaCode = areaCode;
	}

	public String getAddress() {
		return address;
	}

	public void setAddress(String address) {
		this.address = address;
	}

}
