package io.github.xinyangpan.wechat4j.core.dto.xml.pay;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;

import io.github.xinyangpan.wechat4j.core.pay.HasSign;

// https://pay.weixin.qq.com/wiki/doc/api/jsapi.php?chapter=9_1

@JsonInclude(Include.NON_NULL)
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
@JacksonXmlRootElement(localName = "xml")
public class UnifiedOrder implements HasSign {
	// 公众账号ID	appid	是	String(32)	wxd678efh567hg6787	微信支付分配的公众账号ID（企业号corpid即为此appId）
	private String appid;
	// 商户号	mch_id	是	String(32)	1230000109	微信支付分配的商户号
	private String mchId;
	// 设备号	device_info	否	String(32)	013467007045764	自定义参数，可以为终端设备号(门店号或收银设备ID)，PC网页或公众号内支付可以传"WEB"
	private String deviceInfo;
	// 随机字符串	nonce_str	是	String(32)	5K8264ILTKCH16CQ2502SI8ZNMTM67VS	随机字符串，长度要求在32位以内。推荐随机数生成算法
	private String nonceStr;
	// 签名	sign	是	String(32)	C380BEC2BFD727A4B6845133519F3AD6	通过签名算法计算得出的签名值，详见签名生成算法
	private String sign;
	// 签名类型	sign_type	否	String(32)	MD5	签名类型，默认为MD5，支持HMAC-SHA256和MD5。
	private String signType;
	// 商品描述	body	是	String(128)	腾讯充值中心-QQ会员充值 商品简单描述，该字段请按照规范传递，具体请见参数规定
	private String body;
	// 商品详情	detail	否	String(6000)
	private String detail;
	// 附加数据	attach	否	String(127)	深圳分店
	private String attach;
	// 商户订单号	out_trade_no	是	String(32)	20150806125346
	private String outTradeNo;
	// 标价币种	fee_type	否	String(16)	CNY
	private String feeType;
	// 标价金额	total_fee	是	Int	88
	private Integer totalFee;
	// 终端IP	spbill_create_ip	是	String(16)	123.12.12.123
	private String spbillCreateIp;
	// 交易起始时间	time_start	否	String(14)	20091225091010
	private String timeStart;
	// 交易结束时间	time_expire	否	String(14)	20091227091010
	private String timeExpire;
	// 订单优惠标记	goods_tag	否	String(32)	WXG
	private String goodsTag;
	// 通知地址	notify_url	是	String(256)	http://www.weixin.qq.com/wxpay/pay.php
	private String notifyUrl;
	// 交易类型	trade_type	是	String(16)	JSAPI
	private String tradeType;
	// 商品ID	product_id	否	String(32)	12235413214070356458058
	private String productId;
	// 指定支付方式	limit_pay	否	String(32)	no_credit
	private String limitPay;
	// 用户标识	openid	否	String(128)	oUpF8uMuAJO_M2pxb1Q9zNjWeS6o
	private String openid;
	// 用户标识	sceneInfo
	private SceneInfo sceneInfo;
	
	@Override
	public String toString() {
		return String.format("UnifiedOrder [appid=%s, mchId=%s, deviceInfo=%s, nonceStr=%s, sign=%s, signType=%s, body=%s, detail=%s, attach=%s, outTradeNo=%s, feeType=%s, totalFee=%s, spbillCreateIp=%s, timeStart=%s, timeExpire=%s, goodsTag=%s, notifyUrl=%s, tradeType=%s, productId=%s, limitPay=%s, openid=%s, sceneInfo=%s]", appid, mchId, deviceInfo, nonceStr, sign, signType, body, detail, attach, outTradeNo, feeType, totalFee, spbillCreateIp, timeStart, timeExpire, goodsTag, notifyUrl, tradeType, productId, limitPay, openid, sceneInfo);
	}

	public String getAppid() {
		return appid;
	}

	public void setAppid(String appid) {
		this.appid = appid;
	}

	public String getMchId() {
		return mchId;
	}

	public void setMchId(String mchId) {
		this.mchId = mchId;
	}

	public String getDeviceInfo() {
		return deviceInfo;
	}

	public void setDeviceInfo(String deviceInfo) {
		this.deviceInfo = deviceInfo;
	}

	public String getNonceStr() {
		return nonceStr;
	}

	public void setNonceStr(String nonceStr) {
		this.nonceStr = nonceStr;
	}

	public String getSign() {
		return sign;
	}

	public void setSign(String sign) {
		this.sign = sign;
	}

	public String getSignType() {
		return signType;
	}

	public void setSignType(String signType) {
		this.signType = signType;
	}

	public String getBody() {
		return body;
	}

	public void setBody(String body) {
		this.body = body;
	}

	public String getDetail() {
		return detail;
	}

	public void setDetail(String detail) {
		this.detail = detail;
	}

	public String getAttach() {
		return attach;
	}

	public void setAttach(String attach) {
		this.attach = attach;
	}

	public String getOutTradeNo() {
		return outTradeNo;
	}

	public void setOutTradeNo(String outTradeNo) {
		this.outTradeNo = outTradeNo;
	}

	public String getFeeType() {
		return feeType;
	}

	public void setFeeType(String feeType) {
		this.feeType = feeType;
	}

	public Integer getTotalFee() {
		return totalFee;
	}

	public void setTotalFee(Integer totalFee) {
		this.totalFee = totalFee;
	}

	public String getSpbillCreateIp() {
		return spbillCreateIp;
	}

	public void setSpbillCreateIp(String spbillCreateIp) {
		this.spbillCreateIp = spbillCreateIp;
	}

	public String getTimeStart() {
		return timeStart;
	}

	public void setTimeStart(String timeStart) {
		this.timeStart = timeStart;
	}

	public String getTimeExpire() {
		return timeExpire;
	}

	public void setTimeExpire(String timeExpire) {
		this.timeExpire = timeExpire;
	}

	public String getGoodsTag() {
		return goodsTag;
	}

	public void setGoodsTag(String goodsTag) {
		this.goodsTag = goodsTag;
	}

	public String getNotifyUrl() {
		return notifyUrl;
	}

	public void setNotifyUrl(String notifyUrl) {
		this.notifyUrl = notifyUrl;
	}

	public String getTradeType() {
		return tradeType;
	}

	public void setTradeType(String tradeType) {
		this.tradeType = tradeType;
	}

	public String getProductId() {
		return productId;
	}

	public void setProductId(String productId) {
		this.productId = productId;
	}

	public String getLimitPay() {
		return limitPay;
	}

	public void setLimitPay(String limitPay) {
		this.limitPay = limitPay;
	}

	public String getOpenid() {
		return openid;
	}

	public void setOpenid(String openid) {
		this.openid = openid;
	}

	public SceneInfo getSceneInfo() {
		return sceneInfo;
	}

	public void setSceneInfo(SceneInfo sceneInfo) {
		this.sceneInfo = sceneInfo;
	}

}
