package io.github.xinyangpan.wechat4j.core.dto.xml.pay;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;

import io.github.xinyangpan.wechat4j.core.pay.HasSign;

@JsonInclude(Include.NON_NULL)
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
public class UnifiedOrderResult implements HasSign {
	// 返回状态码	return_code	是	String(16)	SUCCESS
	private String returnCode;
	// 返回信息	return_msg	是	String(128)	OK
	private String returnMsg;
	// 公众账号ID	appid	是	String(32)	wx8888888888888888	调用接口提交的公众账号ID
	private String appid;
	// 商户号	mch_id	是	String(32)	1900000109	调用接口提交的商户号
	private String mchId;
	// 设备号	device_info	否	String(32)	013467007045764
	private String deviceInfo;
	// 随机字符串	nonce_str	是	String(32)	5K8264ILTKCH16CQ2502SI8ZNMTM67VS
	private String nonceStr;
	// 签名	sign	是	String(32)	C380BEC2BFD727A4B6845133519F3AD6
	private String sign;
	// 业务结果	result_code	是	String(16)	SUCCESS
	private String resultCode;
	// 错误代码	err_code	否	String(32)
	private String errCode;
	// 错误代码描述	err_code_des	否	String(128)	
	private String errCodeDes;
	// 交易类型	trade_type	是	String(16)	JSAPI
	private String tradeType;
	// 预支付交易会话标识	prepay_id	是	String(64)	wx201410272009395522657a690389285100
	private String prepayId;
	// 二维码链接	code_url	否	String(64)	URl：weixin：//wxpay/s/An4baqw
	private String codeUrl;
	
	@Override
	public String toString() {
		return String.format("UnifiedOrderResult [returnCode=%s, returnMsg=%s, appid=%s, mchId=%s, deviceInfo=%s, nonceStr=%s, sign=%s, resultCode=%s, errCode=%s, errCodeDes=%s, tradeType=%s, prepayId=%s, codeUrl=%s]", returnCode, returnMsg, appid, mchId, deviceInfo, nonceStr, sign, resultCode, errCode, errCodeDes, tradeType, prepayId, codeUrl);
	}

	public String getReturnCode() {
		return returnCode;
	}

	public void setReturnCode(String returnCode) {
		this.returnCode = returnCode;
	}

	public String getReturnMsg() {
		return returnMsg;
	}

	public void setReturnMsg(String returnMsg) {
		this.returnMsg = returnMsg;
	}

	public String getAppid() {
		return appid;
	}

	public void setAppid(String appid) {
		this.appid = appid;
	}

	public String getMchId() {
		return mchId;
	}

	public void setMchId(String mchId) {
		this.mchId = mchId;
	}

	public String getDeviceInfo() {
		return deviceInfo;
	}

	public void setDeviceInfo(String deviceInfo) {
		this.deviceInfo = deviceInfo;
	}

	public String getNonceStr() {
		return nonceStr;
	}

	public void setNonceStr(String nonceStr) {
		this.nonceStr = nonceStr;
	}

	public String getSign() {
		return sign;
	}

	public void setSign(String sign) {
		this.sign = sign;
	}

	public String getResultCode() {
		return resultCode;
	}

	public void setResultCode(String resultCode) {
		this.resultCode = resultCode;
	}

	public String getErrCode() {
		return errCode;
	}

	public void setErrCode(String errCode) {
		this.errCode = errCode;
	}

	public String getErrCodeDes() {
		return errCodeDes;
	}

	public void setErrCodeDes(String errCodeDes) {
		this.errCodeDes = errCodeDes;
	}

	public String getTradeType() {
		return tradeType;
	}

	public void setTradeType(String tradeType) {
		this.tradeType = tradeType;
	}

	public String getPrepayId() {
		return prepayId;
	}

	public void setPrepayId(String prepayId) {
		this.prepayId = prepayId;
	}

	public String getCodeUrl() {
		return codeUrl;
	}

	public void setCodeUrl(String codeUrl) {
		this.codeUrl = codeUrl;
	}

}
