package io.github.xinyangpan.wechat4j.core.oauth;

import io.github.xinyangpan.wechat4j.core.dto.json.UserBaseInfo;

public class Result {
	private UserBaseInfo userBaseInfo;

	public Result() {
	}

	public Result(UserBaseInfo userBaseInfo) {
		this.userBaseInfo = userBaseInfo;
	}

	// is Wechat OAuth2 Callback, or client request 
	public boolean isOAuth2Callback() {
		return userBaseInfo != null;
	}

	@Override
	public String toString() {
		return String.format("OauthResult [userBaseInfo=%s, isCallback()=%s]", userBaseInfo, isOAuth2Callback());
	}

	public UserBaseInfo getUserBaseInfo() {
		return userBaseInfo;
	}

	public void setUserBaseInfo(UserBaseInfo userBaseInfo) {
		this.userBaseInfo = userBaseInfo;
	}

}
