package io.github.xinyangpan.wechat4j.core.pay;

import org.springframework.util.Assert;

public abstract class AbstractOutTradeNoGenerator implements OutTradeNoGenerator {

	public String next() {
		String outTradeNo = this.doGen();
		Assert.notNull(outTradeNo, "Generated outTradeNo can't be null.");
		Assert.state(outTradeNo.length() > 1, "Length must be greater than 1.");
		Assert.state(outTradeNo.length() <= 32, "Length must be less or equal than 32.");
		return outTradeNo;
	}

	protected abstract String doGen();

}
