/*
 * Decompiled with CFR 0.152.
 */
package io.github.xinyangpan.wechat4j;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import io.github.xinyangpan.wechat4j.api.AbstractApi;
import io.github.xinyangpan.wechat4j.api.AbstractBusinessApi;
import io.github.xinyangpan.wechat4j.api.Api;
import io.github.xinyangpan.wechat4j.api.CoreApi;
import io.github.xinyangpan.wechat4j.api.CustomerServiceApi;
import io.github.xinyangpan.wechat4j.api.MenuApi;
import io.github.xinyangpan.wechat4j.api.MessageApi;
import io.github.xinyangpan.wechat4j.api.PayApi;
import io.github.xinyangpan.wechat4j.api.QrCodeApi;
import io.github.xinyangpan.wechat4j.api.TagApi;
import io.github.xinyangpan.wechat4j.api.UserApi;
import io.github.xinyangpan.wechat4j.core.RestWrapper;
import io.github.xinyangpan.wechat4j.core.WechatExtProperties;
import io.github.xinyangpan.wechat4j.core.WechatExtService;
import io.github.xinyangpan.wechat4j.core.listener.IncomeMessageAdaptor;
import io.github.xinyangpan.wechat4j.core.listener.IncomeMessageListener;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.client.RestTemplate;

@EnableConfigurationProperties(value={WechatExtProperties.class})
@Configuration
public class WechatExtAutoConfiguration {
    @Autowired
    private WechatExtProperties wechatExtProperties;

    @Bean
    @ConditionalOnMissingBean
    public RestTemplate restTemplate() {
        ArrayList messageConverters = Lists.newArrayList();
        messageConverters.add(new StringHttpMessageConverter());
        messageConverters.add(new MappingJackson2HttpMessageConverter());
        RestTemplate restTemplate = new RestTemplate((List)messageConverters);
        return restTemplate;
    }

    @Bean
    @ConditionalOnMissingBean
    public ObjectMapper objectMapper() {
        return new ObjectMapper();
    }

    @Bean
    @ConditionalOnMissingBean
    public WechatExtService wechatExtService() {
        WechatExtService wechatExtService = new WechatExtService();
        wechatExtService.setWechatExtProperties(this.wechatExtProperties);
        wechatExtService.setRestWrapper(this.restWrapper());
        return wechatExtService;
    }

    @Bean
    @ConditionalOnMissingBean
    public IncomeMessageListener incomeMessageListener() {
        return new IncomeMessageAdaptor();
    }

    @Bean
    @ConditionalOnMissingBean
    public Api api() {
        Api api = new Api();
        api.setCoreApi(this.coreApi());
        api.setMenuApi(this.menuApi());
        api.setMessageApi(this.messageApi());
        api.setQrCodeApi(this.qrCodeApi());
        api.setTagApi(this.tagApi());
        api.setUserApi(this.userApi());
        api.setPayApi(this.payApi());
        api.setCustomerServiceApi(this.customerServiceApi());
        return api;
    }

    @Bean
    @ConditionalOnMissingBean
    public RestWrapper restWrapper() {
        RestWrapper restWrapper = new RestWrapper();
        restWrapper.setRestTemplate(this.restTemplate());
        restWrapper.setObjectMapper(this.objectMapper());
        return restWrapper;
    }

    @Bean
    @ConditionalOnMissingBean
    public CoreApi coreApi() {
        return this.buildAbstractApi(new CoreApi());
    }

    @Bean
    @ConditionalOnMissingBean
    public MenuApi menuApi() {
        return this.buildAbstractBusinessApi(new MenuApi());
    }

    @Bean
    @ConditionalOnMissingBean
    public MessageApi messageApi() {
        return this.buildAbstractBusinessApi(new MessageApi());
    }

    @Bean
    @ConditionalOnMissingBean
    public TagApi tagApi() {
        return this.buildAbstractBusinessApi(new TagApi());
    }

    @Bean
    @ConditionalOnMissingBean
    public QrCodeApi qrCodeApi() {
        return this.buildAbstractBusinessApi(new QrCodeApi());
    }

    @Bean
    @ConditionalOnMissingBean
    public UserApi userApi() {
        return this.buildAbstractBusinessApi(new UserApi());
    }

    @Bean
    @ConditionalOnMissingBean
    public PayApi payApi() {
        return this.buildAbstractBusinessApi(new PayApi());
    }

    @Bean
    @ConditionalOnMissingBean
    public CustomerServiceApi customerServiceApi() {
        return this.buildAbstractBusinessApi(new CustomerServiceApi());
    }

    public <T extends AbstractBusinessApi> T buildAbstractBusinessApi(T t) {
        this.buildAbstractApi(t);
        t.setCoreApi(this.coreApi());
        return t;
    }

    public <T extends AbstractApi> T buildAbstractApi(T t) {
        t.setRestTemplate(this.restTemplate());
        t.setWechatExtProperties(this.wechatExtProperties);
        t.setWechatExtService(this.wechatExtService());
        return t;
    }
}

