/*
 * Decompiled with CFR 0.152.
 */
package io.github.xinyangpan.wechat4j.api;

import io.github.xinyangpan.wechat4j.api.AbstractApi;
import io.github.xinyangpan.wechat4j.core.dto.WxConfig;
import io.github.xinyangpan.wechat4j.core.dto.json.AccessToken;
import io.github.xinyangpan.wechat4j.core.dto.json.JsapiTicket;
import okhttp3.HttpUrl;
import org.apache.commons.codec.digest.DigestUtils;

public class CoreApi
extends AbstractApi {
    private AccessToken accessToken;
    private JsapiTicket jsapiTicket;

    public WxConfig generateWxConfig(String url) {
        String jsapiTicket = this.currentJsapiTicket();
        String appId = this.wechatExtProperties.getAppId();
        WxConfig wxConfig = new WxConfig(appId);
        String signature = DigestUtils.sha1Hex((String)String.format("jsapi_ticket=%s&noncestr=%s&timestamp=%s&url=%s", jsapiTicket, wxConfig.getNonceStr(), wxConfig.getTimestamp(), url));
        wxConfig.setSignature(signature);
        return wxConfig;
    }

    public synchronized String currentJsapiTicket() {
        if (this.jsapiTicket == null || this.jsapiTicket.isExpired()) {
            this.jsapiTicket = this.jsapiTicket(this.currentAccessToken());
        }
        return this.jsapiTicket.getTicket();
    }

    public synchronized String currentAccessToken() {
        if (this.accessToken == null || this.accessToken.isExpired()) {
            this.accessToken = this.accessToken(this.wechatExtProperties.getAppId(), this.wechatExtProperties.getAppSecret());
        }
        return this.accessToken.getAccessToken();
    }

    private JsapiTicket jsapiTicket(String accessToken) {
        HttpUrl url = this.wechatExtService.commonBuilder().addPathSegment("ticket").addPathSegment("getticket").addQueryParameter("access_token", accessToken).addQueryParameter("type", "jsapi").build();
        JsapiTicket jsapiTicket = (JsapiTicket)this.restTemplate.getForObject(url.toString(), JsapiTicket.class, new Object[0]);
        return (JsapiTicket)jsapiTicket.throwExceptionIfError();
    }

    private AccessToken accessToken(String appId, String appSecret) {
        HttpUrl url = this.wechatExtService.commonBuilder().addPathSegment("token").addQueryParameter("grant_type", "client_credential").addQueryParameter("appid", appId).addQueryParameter("secret", appSecret).build();
        AccessToken accessToken = (AccessToken)this.restTemplate.getForObject(url.toString(), AccessToken.class, new Object[0]);
        return (AccessToken)accessToken.throwExceptionIfError();
    }
}

