/*
 * Decompiled with CFR 0.152.
 */
package io.github.xinyangpan.wechat4j.api;

import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import io.github.xinyangpan.wechat4j.api.AbstractBusinessApi;
import io.github.xinyangpan.wechat4j.core.CoreUtils;
import io.github.xinyangpan.wechat4j.core.dto.xml.pay.UnifiedOrder;
import io.github.xinyangpan.wechat4j.core.dto.xml.pay.UnifiedOrderResult;
import java.io.IOException;
import okhttp3.HttpUrl;

public class PayApi
extends AbstractBusinessApi {
    private final XmlMapper xmlMapper;

    public PayApi() {
        this(CoreUtils.defaultXmlMapper());
    }

    public PayApi(XmlMapper xmlMapper) {
        this.xmlMapper = xmlMapper;
    }

    public UnifiedOrderResult unifiedOrder(UnifiedOrder unifiedOrder) {
        try {
            unifiedOrder = this.wechatExtService.sign(unifiedOrder);
            HttpUrl url = this.wechatExtService.payBuilder().addPathSegment("unifiedorder").build();
            String unifiedOrderXml = this.xmlMapper.writeValueAsString((Object)unifiedOrder);
            String unifiedOrderResultXml = (String)this.restTemplate.postForObject(url.toString(), (Object)unifiedOrderXml, String.class, new Object[0]);
            unifiedOrderResultXml = CoreUtils.utf8ConvertIn(unifiedOrderResultXml);
            this.log.info("Result Xml: {}", (Object)unifiedOrderResultXml);
            UnifiedOrderResult unifiedOrderResult = (UnifiedOrderResult)this.xmlMapper.readValue(unifiedOrderResultXml, UnifiedOrderResult.class);
            return this.wechatExtService.checkSign(unifiedOrderResult);
        }
        catch (IOException e) {
            this.log.error("error for {}.", (Object)unifiedOrder, (Object)e);
            throw new RuntimeException(e);
        }
    }
}

