/*
 * Decompiled with CFR 0.152.
 */
package io.github.xinyangpan.wechat4j.controller;

import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import io.github.xinyangpan.wechat4j.api.Api;
import io.github.xinyangpan.wechat4j.core.CoreUtils;
import io.github.xinyangpan.wechat4j.core.WechatExtProperties;
import io.github.xinyangpan.wechat4j.core.WechatExtService;
import io.github.xinyangpan.wechat4j.core.dto.PayInfo;
import io.github.xinyangpan.wechat4j.core.dto.WxConfig;
import io.github.xinyangpan.wechat4j.core.dto.xml.pay.PayCallbackInfo;
import io.github.xinyangpan.wechat4j.core.dto.xml.pay.PayCallbackResult;
import io.github.xinyangpan.wechat4j.core.listener.IncomeMessageListener;
import io.github.xinyangpan.wechat4j.core.oauth.Scope;
import io.github.xinyangpan.wechat4j.core.pay.WechatPayService;
import java.io.IOException;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/wechat"})
public class WechatExtController {
    private static final Logger log = LoggerFactory.getLogger(WechatExtController.class);
    @Autowired
    private WechatExtProperties wechatExtProperties;
    @Autowired
    private WechatExtService wechatExtService;
    @Autowired
    private Api api;
    private XmlMapper xmlMapper = CoreUtils.defaultXmlMapper();
    @Autowired
    private IncomeMessageListener incomeMessageListener;
    @Autowired
    private WechatPayService wechatPayService;

    @RequestMapping(method={RequestMethod.GET})
    @ResponseBody
    public String token(@RequestParam(value="signature") String signature, @RequestParam(value="echostr") String echostr, @RequestParam(value="timestamp") String timestamp, @RequestParam(value="nonce") String nonce) {
        if (!this.wechatExtService.isSignatureValid(signature, this.wechatExtProperties.getToken(), timestamp, nonce)) {
            log.warn("invalid signature: " + signature);
            return "fail";
        }
        return echostr;
    }

    @RequestMapping(value={"/redirect"}, method={RequestMethod.GET})
    public void weixinRedirect(HttpServletRequest request, HttpServletResponse response, Optional<Scope> scope) throws IOException {
        this.wechatExtService.redirectToOAuth2Server(response, this.wechatExtProperties.getRedirectUri(), scope.orElse(Scope.snsapi_base));
        log.debug("Redirected for scope={}.", scope);
    }

    @RequestMapping(method={RequestMethod.POST}, consumes={"text/xml"})
    @ResponseBody
    public String business(@RequestParam(value="signature") String signature, @RequestParam(value="timestamp") String timestamp, @RequestParam(value="nonce") String nonce, @RequestBody String content) throws IOException {
        if (!this.wechatExtService.isSignatureValid(signature, this.wechatExtProperties.getToken(), timestamp, nonce)) {
            log.warn("invalid signature: " + signature);
            return "fail";
        }
        log.info("business method. content:\n{}", (Object)content);
        return this.incomeMessageListener.onMessage(content);
    }

    @GetMapping(value={"/wxConfig"})
    @ResponseBody
    public WxConfig wxConfig(@RequestParam String url) {
        log.info("requsting wx config for {}.", (Object)url);
        return this.api.core().generateWxConfig(url);
    }

    @PostMapping(value={"/pay"})
    @ResponseBody
    public PayInfo pay(HttpServletRequest request, HttpServletResponse response) {
        log.info("Pay: {}.", (Object)request.getParameter("billId"));
        return this.wechatExtService.sign(this.wechatPayService.pay(request));
    }

    @PostMapping(value={"/payCallback"})
    @ResponseBody
    public PayCallbackResult payCallback(@RequestBody String callbackInfo) throws IOException {
        log.info("CallbackInfo info: {}.", (Object)callbackInfo);
        PayCallbackInfo payCallbackInfo = (PayCallbackInfo)this.xmlMapper.readValue(callbackInfo, PayCallbackInfo.class);
        log.info("PayCallback info: {}.", (Object)payCallbackInfo);
        this.wechatExtService.checkSign(payCallbackInfo);
        return this.wechatPayService.payCallback(payCallbackInfo);
    }

    public WechatExtProperties getWechatExtProperties() {
        return this.wechatExtProperties;
    }

    public void setWechatExtProperties(WechatExtProperties wechatExtProperties) {
        this.wechatExtProperties = wechatExtProperties;
    }

    public IncomeMessageListener getIncomeMessageListener() {
        return this.incomeMessageListener;
    }

    public void setIncomeMessageListener(IncomeMessageListener incomeMessageListener) {
        this.incomeMessageListener = incomeMessageListener;
    }

    public WechatExtService getWechatExtService() {
        return this.wechatExtService;
    }

    public void setWechatExtService(WechatExtService wechatExtService) {
        this.wechatExtService = wechatExtService;
    }
}

