/*
 * Decompiled with CFR 0.152.
 */
package io.github.xinyangpan.wechat4j.core;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.client.RestTemplate;

public class RestWrapper {
    private static final Logger log = LoggerFactory.getLogger(RestWrapper.class);
    private RestTemplate restTemplate;
    private ObjectMapper objectMapper;

    public <T> T getForObject(String url, Class<T> responseType, Object ... uriVariables) {
        String responseString = (String)this.restTemplate.getForObject(url, String.class, uriVariables);
        log.info("responseString is {}", (Object)responseString);
        try {
            return (T)this.objectMapper.readValue(responseString, responseType);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

