/*
 * Decompiled with CFR 0.152.
 */
package io.github.xinyangpan.wechat4j.core;

import com.google.common.base.Joiner;
import io.github.xinyangpan.wechat4j.core.CoreUtils;
import io.github.xinyangpan.wechat4j.core.RestWrapper;
import io.github.xinyangpan.wechat4j.core.WechatExtProperties;
import io.github.xinyangpan.wechat4j.core.dto.json.UserBaseInfo;
import io.github.xinyangpan.wechat4j.core.dto.xml.pay.UnifiedOrder;
import io.github.xinyangpan.wechat4j.core.oauth.Result;
import io.github.xinyangpan.wechat4j.core.oauth.Scope;
import io.github.xinyangpan.wechat4j.core.pay.HasSign;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import okhttp3.HttpUrl;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class WechatExtService {
    private static final Logger log = LoggerFactory.getLogger(WechatExtService.class);
    private static String BUSINESS_URL = "https://api.weixin.qq.com/cgi-bin";
    private static String CS_URL = "https://api.weixin.qq.com/customservice";
    private static String PAY_URL = "https://api.mch.weixin.qq.com/pay";
    private RestWrapper restWrapper;
    private WechatExtProperties wechatExtProperties;

    public HttpUrl.Builder commonBuilder() {
        return HttpUrl.parse((String)BUSINESS_URL).newBuilder();
    }

    public HttpUrl.Builder csBuilder() {
        return HttpUrl.parse((String)CS_URL).newBuilder();
    }

    public HttpUrl.Builder payBuilder() {
        return HttpUrl.parse((String)PAY_URL).newBuilder();
    }

    public String authorizeUrl(Scope scope) {
        return this.authorizeUrl(scope, this.wechatExtProperties.getRedirectUri());
    }

    public String authorizeUrl(Scope scope, String redirectUri) {
        String appId = this.wechatExtProperties.getAppId();
        String responseType = "code";
        return HttpUrl.parse((String)"https://open.weixin.qq.com/connect/oauth2/authorize").newBuilder().addQueryParameter("appid", appId).addQueryParameter("redirect_uri", redirectUri).addQueryParameter("response_type", responseType).addQueryParameter("scope", scope.name()).addQueryParameter("state", this.wechatExtProperties.getOauthState()).encodedFragment("wechat_redirect").toString();
    }

    public UserBaseInfo userBaseInfo(String code) {
        String url = HttpUrl.parse((String)"https://api.weixin.qq.com/sns/oauth2/access_token").newBuilder().addQueryParameter("appid", this.wechatExtProperties.getAppId()).addQueryParameter("secret", this.wechatExtProperties.getAppSecret()).addQueryParameter("code", code).addQueryParameter("grant_type", "authorization_code").toString();
        return this.restWrapper.getForObject(url, UserBaseInfo.class, new Object[0]);
    }

    public boolean isSignatureValid(String signature, String token, String timestamp, String nonce) {
        log.debug("isSignatureValid: signature={}, token={}, timestamp={}, nonce={}", new Object[]{signature, token, timestamp, nonce});
        Object[] strs = new String[]{token, timestamp, nonce};
        Arrays.sort(strs);
        String concat = Joiner.on((String)"").join(strs);
        String calculateSignature = DigestUtils.sha1Hex((String)concat);
        log.debug("Calculated Signature: {}", (Object)calculateSignature);
        return Objects.equals(signature, calculateSignature);
    }

    public long now() {
        return System.currentTimeMillis();
    }

    public boolean isStateValid(String state) {
        if (Objects.equals(this.wechatExtProperties.getOauthState(), state)) {
            return true;
        }
        log.error("Illegal Wechat OAuth2 state. expected: {}, actual: {}", (Object)this.wechatExtProperties.getOauthState(), (Object)state);
        return false;
    }

    public void validateState(HttpServletRequest request) {
        String state = request.getParameter("state");
        if (!this.isStateValid(state)) {
            throw new IllegalStateException("Illegal Wechat OAuth2 state Exception.");
        }
    }

    public UserBaseInfo getUserBaseInfo(HttpServletRequest request) {
        String code = request.getParameter("code");
        if (code == null) {
            throw new IllegalArgumentException("Code value not found.");
        }
        this.validateState(request);
        return this.userBaseInfo(code);
    }

    public void redirectToOAuth2Server(HttpServletResponse response, String redirectUri, Scope scope) throws IOException {
        String url = this.authorizeUrl(scope, redirectUri);
        log.debug("redirect URL - {}", (Object)url);
        response.sendRedirect(url);
    }

    public Result intercept(HttpServletRequest request, HttpServletResponse response, String redirectUri, Scope scope) throws IOException {
        String code = request.getParameter("code");
        if (code != null) {
            log.debug("WeChat OAuth Server Callback.");
            return new Result(this.getUserBaseInfo(request));
        }
        log.debug("Client request.");
        this.redirectToOAuth2Server(response, redirectUri, scope);
        return new Result(null);
    }

    public UnifiedOrder createUnifiedOrder() {
        UnifiedOrder unifiedOrder = new UnifiedOrder();
        unifiedOrder.setAppid(this.wechatExtProperties.getAppId());
        unifiedOrder.setMchId(this.wechatExtProperties.getMchId());
        unifiedOrder.setNonceStr(CoreUtils.nextNonceString(24));
        unifiedOrder.setNotifyUrl(this.wechatExtProperties.getPayNotifyUrl());
        unifiedOrder.setTradeType("JSAPI");
        return unifiedOrder;
    }

    public <T extends HasSign> T sign(T t) {
        t.setSign(this.getSign(t));
        return t;
    }

    public <T extends HasSign> T checkSign(T t) {
        if (t.getSign() == null) {
            return t;
        }
        String sign = this.getSign(t);
        Assert.isTrue((boolean)Objects.equals(t.getSign(), sign), (String)"Sign DO NOT match.");
        return t;
    }

    private <T extends HasSign> String getSign(T t) {
        TreeMap sortedMap = new TreeMap((Map)CoreUtils.defaultObjectMapper().convertValue(t, Map.class));
        t.removeKeys().forEach(sortedMap::remove);
        String stringSignTemp = sortedMap.entrySet().stream().map(e -> String.format("%s=%s", e.getKey(), e.getValue())).collect(Collectors.joining("&")) + "&key=" + this.wechatExtProperties.getPayKey();
        return DigestUtils.md5Hex((String)stringSignTemp).toUpperCase();
    }

    public WechatExtProperties getWechatExtProperties() {
        return this.wechatExtProperties;
    }

    public void setWechatExtProperties(WechatExtProperties wechatExtProperties) {
        this.wechatExtProperties = wechatExtProperties;
    }

    public RestWrapper getRestWrapper() {
        return this.restWrapper;
    }

    public void setRestWrapper(RestWrapper restWrapper) {
        this.restWrapper = restWrapper;
    }
}

