/*
 * Decompiled with CFR 0.152.
 */
package io.github.xinyangpan.wechat4j.core.listener;

import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import io.github.xinyangpan.wechat4j.core.CoreUtils;
import io.github.xinyangpan.wechat4j.core.dto.xml.Xml;
import io.github.xinyangpan.wechat4j.core.dto.xml.XmlEvent;
import io.github.xinyangpan.wechat4j.core.dto.xml.XmlText;
import io.github.xinyangpan.wechat4j.core.listener.IncomeMessageListener;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncomeMessageAdaptor
implements IncomeMessageListener {
    private Logger log = LoggerFactory.getLogger(IncomeMessageListener.class);
    protected final XmlMapper xmlMapper;

    public IncomeMessageAdaptor() {
        this(CoreUtils.defaultXmlMapper());
    }

    public IncomeMessageAdaptor(XmlMapper xmlMapper) {
        this.xmlMapper = xmlMapper;
    }

    @Override
    public String onMessage(String message) throws IOException {
        Xml xml = (Xml)this.xmlMapper.readValue(message, Xml.class);
        switch (xml.getMsgType()) {
            case text: {
                return this.onText((XmlText)this.xmlMapper.readValue(message, XmlText.class));
            }
            case event: {
                return this.onEvent((XmlEvent)this.xmlMapper.readValue(message, XmlEvent.class));
            }
        }
        this.log.info("Not Supported Msg, {}", (Object)message);
        return "";
    }

    public String onText(XmlText in) throws IOException {
        return "";
    }

    public String onEvent(XmlEvent xmlEvent) throws IOException {
        switch (xmlEvent.getEvent()) {
            case subscribe: {
                return this.onSubscribeEvent(xmlEvent);
            }
            case unsubscribe: {
                return this.onUnsubscribeEvent(xmlEvent);
            }
            case TEMPLATESENDJOBFINISH: {
                return this.onTemplateSendJobFinishEvent(xmlEvent);
            }
            case VIEW: {
                return this.onViewEvent(xmlEvent);
            }
            case SCAN: {
                return this.onScanEvent(xmlEvent);
            }
        }
        return "success";
    }

    protected String onScanEvent(XmlEvent xmlEvent) throws IOException {
        return "";
    }

    protected String onSubscribeEvent(XmlEvent xmlEvent) throws IOException {
        return "";
    }

    protected String onUnsubscribeEvent(XmlEvent xmlEvent) throws IOException {
        return "";
    }

    protected String onTemplateSendJobFinishEvent(XmlEvent xmlEvent) throws IOException {
        return "";
    }

    protected String onViewEvent(XmlEvent xmlEvent) throws IOException {
        return "";
    }
}

