/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.system;

import io.hawt.system.AuthInfo;
import io.hawt.system.AuthenticateResult;
import io.hawt.web.auth.AuthenticationConfiguration;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AccountException;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;
import org.apache.karaf.jaas.boot.principal.ClientPrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Authenticator {
    private static final transient Logger LOG = LoggerFactory.getLogger(Authenticator.class);
    public static final String HEADER_AUTHORIZATION = "Authorization";
    public static final String AUTHENTICATION_SCHEME_BASIC = "Basic";
    private static Boolean websphereDetected;
    private static Method websphereGetGroupsMethod;

    public static void extractAuthInfo(String authHeader, BiConsumer<String, String> callback) {
        String[] parts = (authHeader = authHeader.trim()).split(" ");
        if (parts.length != 2) {
            return;
        }
        String authType = parts[0];
        String authInfo = parts[1];
        if (authType.equalsIgnoreCase(AUTHENTICATION_SCHEME_BASIC)) {
            String decoded = new String(Base64.decodeBase64((String)authInfo));
            int delimiter = decoded.indexOf(58);
            if (delimiter < 0) {
                return;
            }
            String user = decoded.substring(0, delimiter);
            String password = decoded.substring(delimiter + 1);
            callback.accept(user, password);
        }
    }

    public static void logout(AuthenticationConfiguration authConfiguration, Subject subject) {
        try {
            LoginContext loginContext = new LoginContext(authConfiguration.getRealm(), subject);
            loginContext.logout();
        }
        catch (Exception e) {
            LOG.warn("Error occurred while logging out", (Throwable)e);
        }
    }

    public static AuthenticateResult authenticate(AuthenticationConfiguration authConfiguration, HttpServletRequest request, Consumer<Subject> callback) {
        String authHeader = request.getHeader(HEADER_AUTHORIZATION);
        if (authHeader == null || authHeader.equals("")) {
            return AuthenticateResult.NO_CREDENTIALS;
        }
        AuthInfo info = new AuthInfo();
        Authenticator.extractAuthInfo(authHeader, (userName, password) -> {
            info.username = userName;
            info.password = password;
        });
        if (info.username == null || info.username.equals("public")) {
            return AuthenticateResult.NO_CREDENTIALS;
        }
        if (info.isSet()) {
            return Authenticator.authenticate(authConfiguration, request, info.username, info.password, callback);
        }
        return AuthenticateResult.NO_CREDENTIALS;
    }

    public static AuthenticateResult authenticate(AuthenticationConfiguration authConfiguration, HttpServletRequest request, String username, String password, Consumer<Subject> callback) {
        Subject subject = Authenticator.doAuthenticate(request, authConfiguration.getRealm(), authConfiguration.getRole(), authConfiguration.getRolePrincipalClasses(), authConfiguration.getConfiguration(), username, password);
        if (subject == null) {
            return AuthenticateResult.NOT_AUTHORIZED;
        }
        if (callback != null) {
            try {
                callback.accept(subject);
            }
            catch (Exception e) {
                LOG.warn("Failed to execute privileged action:", (Throwable)e);
            }
        }
        return AuthenticateResult.AUTHORIZED;
    }

    private static Subject doAuthenticate(HttpServletRequest request, String realm, String role, String rolePrincipalClasses, Configuration configuration, String username, String password) {
        try {
            boolean found;
            LOG.debug("doAuthenticate[realm={}, role={}, rolePrincipalClasses={}, configuration={}, username={}, password={}]", new Object[]{realm, role, rolePrincipalClasses, configuration, username, "******"});
            Subject subject = new Subject();
            try {
                String addr = request.getRemoteHost() + ":" + request.getRemotePort();
                subject.getPrincipals().add((Principal)new ClientPrincipal("hawtio", addr));
            }
            catch (Throwable addr) {
                // empty catch block
            }
            AuthenticationCallbackHandler handler = new AuthenticationCallbackHandler(username, password);
            LoginContext loginContext = configuration != null ? new LoginContext(realm, subject, handler, configuration) : new LoginContext(realm, subject, handler);
            loginContext.login();
            if (role == null || role.equals("")) {
                LOG.debug("Skipping role check, no role configured");
                return subject;
            }
            if (role.equals("*")) {
                LOG.debug("Skipping role check, all roles allowed");
                return subject;
            }
            if (Authenticator.isRunningOnWebsphere(subject)) {
                found = Authenticator.checkIfSubjectHasRequiredRoleOnWebsphere(subject, role);
            } else {
                if (rolePrincipalClasses == null || rolePrincipalClasses.equals("")) {
                    LOG.debug("Skipping role check, no rolePrincipalClasses configured");
                    return subject;
                }
                found = Authenticator.checkIfSubjectHasRequiredRole(subject, role, rolePrincipalClasses);
            }
            if (!found) {
                LOG.debug("User {} does not have the required role {}", (Object)username, (Object)role);
                return null;
            }
            return subject;
        }
        catch (AccountException e) {
            LOG.warn("Account failure", (Throwable)e);
        }
        catch (LoginException e) {
            LOG.warn("Login failed due to: {}", (Object)e.getMessage());
            LOG.debug("Failed stacktrace:", (Throwable)e);
        }
        return null;
    }

    private static boolean checkIfSubjectHasRequiredRole(Subject subject, String role, String rolePrincipalClasses) {
        String[] roleArray = role.split(",");
        String[] rolePrincipalClazzes = rolePrincipalClasses.split(",");
        boolean found = false;
        for (String clazz : rolePrincipalClazzes) {
            LOG.debug("Looking for rolePrincipalClass: {}", (Object)clazz);
            for (Principal p : subject.getPrincipals()) {
                LOG.debug("Checking principal, classname: {} toString: {}", (Object)p.getClass().getName(), (Object)p);
                if (!p.getClass().getName().equals(clazz.trim())) {
                    LOG.debug("principal class {} doesn't match {}, continuing", (Object)p.getClass().getName(), (Object)clazz.trim());
                    continue;
                }
                for (String r : roleArray) {
                    if (r != null && p.getName().equals(r.trim())) {
                        LOG.debug("Matched role and role principal class");
                        found = true;
                        break;
                    }
                    LOG.debug("role {} doesn't match {}, continuing", (Object)p.getName(), (Object)r);
                }
                if (!found) continue;
                break;
            }
            if (found) break;
        }
        return found;
    }

    private static boolean isRunningOnWebsphere(Subject subject) {
        if (websphereDetected == null) {
            boolean onWebsphere = false;
            for (Principal p : subject.getPrincipals()) {
                LOG.trace("Checking principal for IBM specific interfaces: {}", (Object)p);
                onWebsphere = Authenticator.implementsInterface(p, "com.ibm.websphere.security.auth.WSPrincipal");
            }
            LOG.trace("Checking if we are running using a IBM Websphere specific LoginModule: {}", (Object)onWebsphere);
            websphereDetected = onWebsphere;
        }
        return websphereDetected;
    }

    private static boolean checkIfSubjectHasRequiredRoleOnWebsphere(Subject subject, String role) {
        LOG.debug("Running on websphere: checking if the Role {} is in the set of groups in WSCredential", (Object)role);
        for (Object cred : subject.getPublicCredentials()) {
            LOG.debug("Checking credential {} if it is a WebSphere specific WSCredential containing group info", cred);
            if (!Authenticator.implementsInterface(cred, "com.ibm.websphere.security.cred.WSCredential")) continue;
            try {
                Method groupsMethod = Authenticator.getWebSphereGetGroupsMethod(cred);
                List groups = (List)groupsMethod.invoke(cred, new Object[0]);
                if (groups != null) {
                    LOG.debug("Found a total of {} groups in the IBM WebSphere Credentials", (Object)groups.size());
                    for (Object group : groups) {
                        String[] roleArray;
                        LOG.debug("Matching IBM Websphere group name {} to required role {}", group, (Object)role);
                        for (String r : roleArray = role.split(",")) {
                            if (r.equals(group.toString())) {
                                LOG.debug("Required role {} found in IBM WebSphere specific credentials", (Object)r);
                                return true;
                            }
                            LOG.debug("role {} doesn't match {}, continuing", (Object)r, (Object)group.toString());
                        }
                    }
                    continue;
                }
                LOG.debug("The IBM Websphere groups list is null");
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                LOG.debug("Caught exception trying to read groups from WebSphere specific WSCredentials class", (Throwable)e);
            }
        }
        return false;
    }

    private static Method getWebSphereGetGroupsMethod(Object cred) throws NoSuchMethodException {
        if (websphereGetGroupsMethod == null) {
            websphereGetGroupsMethod = cred.getClass().getMethod("getGroupIds", new Class[0]);
        }
        return websphereGetGroupsMethod;
    }

    private static boolean implementsInterface(Object o, String interfaceName) {
        boolean implementsIf = false;
        for (Class<?> pif : o.getClass().getInterfaces()) {
            LOG.trace("Checking interface {} if it matches {}", pif, (Object)interfaceName);
            if (!pif.getName().equals(interfaceName)) continue;
            implementsIf = true;
            break;
        }
        return implementsIf;
    }

    private static final class AuthenticationCallbackHandler
    implements CallbackHandler {
        private final String username;
        private final String password;

        private AuthenticationCallbackHandler(String username, String password) {
            this.username = username;
            this.password = password;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback callback : callbacks) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Callback type {} -> {}", callback.getClass(), (Object)callback);
                }
                if (callback instanceof NameCallback) {
                    ((NameCallback)callback).setName(this.username);
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    ((PasswordCallback)callback).setPassword(this.password.toCharArray());
                    continue;
                }
                LOG.debug("Unknown callback class [" + callback.getClass().getName() + "]");
            }
        }
    }
}

