/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.web.auth;

import io.hawt.system.AuthHelpers;
import io.hawt.system.AuthenticateResult;
import io.hawt.system.Authenticator;
import io.hawt.system.ConfigManager;
import io.hawt.web.ServletHelpers;
import io.hawt.web.auth.AuthenticationConfiguration;
import io.hawt.web.auth.Redirector;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.Principal;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import javax.security.auth.Subject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jolokia.converter.Converters;
import org.jolokia.converter.json.JsonConvertOptions;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginServlet
extends HttpServlet {
    private static final long serialVersionUID = 187076436862364207L;
    private static final transient Logger LOG = LoggerFactory.getLogger(LoginServlet.class);
    private static final int DEFAULT_SESSION_TIMEOUT = 1800;
    private Integer timeout = 1800;
    private AuthenticationConfiguration authConfiguration;
    private Converters converters = new Converters();
    private JsonConvertOptions options = JsonConvertOptions.DEFAULT;
    private Redirector redirector = new Redirector();

    public void init() {
        this.authConfiguration = AuthenticationConfiguration.getConfiguration(this.getServletContext());
        this.setupSessionTimeout();
        LOG.info("hawtio login is using {} HttpSession timeout", (Object)(this.timeout != null ? this.timeout + " sec." : "default"));
    }

    private void setupSessionTimeout() {
        ConfigManager configManager = (ConfigManager)this.getServletContext().getAttribute("ConfigManager");
        if (configManager == null) {
            return;
        }
        String timeoutStr = configManager.get("sessionTimeout", Integer.toString(1800));
        if (timeoutStr == null) {
            return;
        }
        try {
            this.timeout = Integer.valueOf(timeoutStr);
            if (this.timeout == 0) {
                this.timeout = 1800;
            }
        }
        catch (Exception e) {
            this.timeout = 1800;
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.authConfiguration.isKeycloakEnabled()) {
            this.redirector.doRedirect(request, response, "/");
        } else {
            this.redirector.doForward(request, response, "/login.html");
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.clearSession(request);
        JSONObject json = ServletHelpers.readObject(request.getReader());
        String username = (String)json.get("username");
        String password = (String)json.get("password");
        AuthenticateResult result = Authenticator.authenticate(this.authConfiguration, request, username, password, subject -> {
            LOG.info("Logging in user: {}", (Object)AuthHelpers.getUsername(subject));
            this.setupSession(request, (Subject)subject, username);
            this.sendResponse(response, (Subject)subject);
        });
        switch (result) {
            case AUTHORIZED: {
                break;
            }
            case NOT_AUTHORIZED: 
            case NO_CREDENTIALS: {
                ServletHelpers.doForbidden(response);
            }
        }
    }

    private void clearSession(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return;
        }
        Subject subject = (Subject)session.getAttribute("subject");
        if (subject != null) {
            LOG.info("Logging out existing user: {}", (Object)AuthHelpers.getUsername(subject));
            Authenticator.logout(this.authConfiguration, subject);
            session.invalidate();
        }
    }

    private void setupSession(HttpServletRequest request, Subject subject, String username) {
        HttpSession session = request.getSession(true);
        session.setAttribute("subject", (Object)subject);
        session.setAttribute("user", (Object)username);
        session.setAttribute("org.osgi.service.http.authentication.remote.user", (Object)username);
        session.setAttribute("org.osgi.service.http.authentication.type", (Object)"BASIC");
        session.setAttribute("loginTime", (Object)GregorianCalendar.getInstance().getTimeInMillis());
        if (this.timeout != null) {
            session.setMaxInactiveInterval(this.timeout.intValue());
        }
        LOG.debug("Http session timeout for user {} is {} sec.", (Object)username, (Object)session.getMaxInactiveInterval());
    }

    private void sendResponse(HttpServletResponse response, Subject subject) {
        response.setContentType("application/json");
        try (PrintWriter out = response.getWriter();){
            HashMap answer = new HashMap();
            ArrayList principals = new ArrayList();
            for (Principal principal : subject.getPrincipals()) {
                HashMap<String, String> data = new HashMap<String, String>();
                data.put("type", principal.getClass().getName());
                data.put("name", principal.getName());
                principals.add(data);
            }
            ArrayList credentials = new ArrayList();
            for (Object credential : subject.getPublicCredentials()) {
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("type", credential.getClass().getName());
                data.put("credential", credential);
                credentials.add(data);
            }
            answer.put("principals", principals);
            answer.put("credentials", credentials);
            ServletHelpers.writeObject(this.converters, this.options, out, answer);
        }
        catch (IOException e) {
            LOG.error("Failed to send response", (Throwable)e);
        }
    }

    public void setRedirector(Redirector redirector) {
        this.redirector = redirector;
    }
}

