/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.accesscontrol.broadcastlistener;

import io.joynr.accesscontrol.DomainAccessControlStore;
import joynr.infrastructure.DacTypes.ChangeType;
import joynr.infrastructure.DacTypes.MasterAccessControlEntry;
import joynr.infrastructure.GlobalDomainAccessControllerBroadcastInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdacMediatorAccessControlEntryChangedBroadcastListener
implements GlobalDomainAccessControllerBroadcastInterface.MediatorAccessControlEntryChangedBroadcastListener {
    private static final Logger LOG = LoggerFactory.getLogger(LdacMediatorAccessControlEntryChangedBroadcastListener.class);
    private DomainAccessControlStore localDomainAccessStore;

    public LdacMediatorAccessControlEntryChangedBroadcastListener(DomainAccessControlStore domainAccessControlStore) {
        this.localDomainAccessStore = domainAccessControlStore;
    }

    public void onReceive(ChangeType typeOfChange, MasterAccessControlEntry newMediatorAce) {
        if (!typeOfChange.equals((Object)ChangeType.REMOVE)) {
            this.localDomainAccessStore.updateMediatorAccessControlEntry(newMediatorAce);
            LOG.debug("Updated mediator ACE: {}", (Object)newMediatorAce.toString());
        } else {
            this.localDomainAccessStore.removeMediatorAccessControlEntry(newMediatorAce.getUid(), newMediatorAce.getDomain(), newMediatorAce.getInterfaceName(), newMediatorAce.getOperation());
            LOG.debug("Removed mediator ACE: {}", (Object)newMediatorAce.toString());
        }
    }

    public void onError() {
        LOG.error("Update mediatorAce failed!");
    }
}

