/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.channel;

import com.google.inject.Inject;
import io.joynr.exceptions.JoynrMessageNotSentException;
import io.joynr.exceptions.JoynrSendBufferFullException;
import io.joynr.messaging.FailureAction;
import io.joynr.messaging.IMessagingSkeleton;
import io.joynr.messaging.MessageArrivedListener;
import io.joynr.messaging.MessageReceiver;
import io.joynr.messaging.ReceiverStatusListener;
import io.joynr.messaging.routing.MessageRouter;
import joynr.JoynrMessage;
import joynr.system.RoutingTypes.Address;
import joynr.system.RoutingTypes.RoutingTypesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelMessagingSkeleton
implements IMessagingSkeleton {
    private final MessageRouter messageRouter;
    private static final Logger logger = LoggerFactory.getLogger(ChannelMessagingSkeleton.class);
    private MessageReceiver messageReceiver;

    @Inject
    public ChannelMessagingSkeleton(MessageRouter messageRouter, MessageReceiver messageReceiver) {
        this.messageRouter = messageRouter;
        this.messageReceiver = messageReceiver;
    }

    public void transmit(JoynrMessage message, FailureAction failureAction) {
        String replyToChannelId = message.getHeaderValue("replyChannelId");
        try {
            this.addRequestorToMessageRouter(message.getFrom(), replyToChannelId);
            this.messageRouter.route(message);
        }
        catch (JoynrMessageNotSentException | JoynrSendBufferFullException exception) {
            logger.error("Error processing incoming message. Message will be dropped: {} ", (Object)message.getHeader(), (Object)exception);
            failureAction.execute(exception);
        }
    }

    public void transmit(String serializedMessage, FailureAction failureAction) {
    }

    private void addRequestorToMessageRouter(String requestorParticipantId, String replyToSerializedAddress) {
        if (replyToSerializedAddress != null && !replyToSerializedAddress.isEmpty()) {
            Address address = RoutingTypesUtil.fromAddressString((String)replyToSerializedAddress);
            this.messageRouter.addNextHop(requestorParticipantId, address);
        }
    }

    public void init() {
        this.messageReceiver.start(new MessageArrivedListener(){

            public void messageArrived(final JoynrMessage message) {
                ChannelMessagingSkeleton.this.transmit(message, new FailureAction(){

                    public void execute(Throwable error) {
                        logger.error("error processing incoming message: {} error: {}", (Object)message.getId(), (Object)error.getMessage());
                    }
                });
            }

            public void error(JoynrMessage message, Throwable error) {
                logger.error("error receiving incoming message: {} error: {}", (Object)message.getId(), (Object)error.getMessage());
            }
        }, new ReceiverStatusListener[]{new ReceiverStatusListener(){

            public void receiverStarted() {
            }

            public void receiverException(Throwable e) {
                logger.error("error in long polling message receiver error: {}", (Object)e.getMessage());
                ChannelMessagingSkeleton.this.shutdown();
            }
        }});
    }

    public void shutdown() {
        this.messageReceiver.shutdown(false);
    }
}

