/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.channel;

import com.google.inject.Inject;
import io.joynr.messaging.AbstractMiddlewareMessagingStubFactory;
import io.joynr.messaging.JoynrMessageSerializer;
import io.joynr.messaging.channel.ChannelMessageSerializerFactory;
import io.joynr.messaging.channel.ChannelMessagingStub;
import io.joynr.messaging.http.HttpGlobalAddressFactory;
import io.joynr.messaging.http.HttpMessageSender;
import io.joynr.messaging.routing.GlobalAddressFactory;
import java.util.Set;
import joynr.system.RoutingTypes.Address;
import joynr.system.RoutingTypes.ChannelAddress;

public class ChannelMessagingStubFactory
extends AbstractMiddlewareMessagingStubFactory<ChannelMessagingStub, ChannelAddress> {
    private HttpMessageSender httpMessageSender;
    private ChannelMessageSerializerFactory channelMessageSerializerFactory;
    private HttpGlobalAddressFactory channelAddressFactory;

    @Inject
    public ChannelMessagingStubFactory(ChannelMessageSerializerFactory channelMessageSerializerFactory, HttpMessageSender messageSender, Set<GlobalAddressFactory<? extends Address>> addressFactories) {
        this.channelMessageSerializerFactory = channelMessageSerializerFactory;
        this.httpMessageSender = messageSender;
        for (GlobalAddressFactory<? extends Address> addressFactory : addressFactories) {
            if (!(addressFactory instanceof HttpGlobalAddressFactory)) continue;
            this.channelAddressFactory = (HttpGlobalAddressFactory)addressFactory;
        }
        if (this.channelAddressFactory == null) {
            throw new IllegalStateException("A http global address factory must be registered if using channel messaging via HTTP");
        }
    }

    protected ChannelMessagingStub createInternal(ChannelAddress address) {
        JoynrMessageSerializer messageSerializer = this.channelMessageSerializerFactory.create((Address)address);
        ChannelAddress replyToAddress = this.channelAddressFactory.create();
        ChannelMessagingStub messagingStub = new ChannelMessagingStub(address, replyToAddress, messageSerializer, this.httpMessageSender);
        return messagingStub;
    }

    public void shutdown() {
        this.httpMessageSender.shutdown();
    }
}

