/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.joynr.exceptions.JoynrChannelMissingException;
import io.joynr.exceptions.JoynrCommunicationException;
import io.joynr.exceptions.JoynrDelayMessageException;
import io.joynr.exceptions.JoynrMessageNotSentException;
import io.joynr.exceptions.JoynrShutdownException;
import io.joynr.messaging.FailureAction;
import io.joynr.messaging.MessageReceiver;
import io.joynr.messaging.datatypes.JoynrMessagingError;
import io.joynr.messaging.datatypes.JoynrMessagingErrorCode;
import io.joynr.messaging.http.IMessageSender;
import io.joynr.messaging.http.UrlResolver;
import io.joynr.messaging.http.operation.HttpConstants;
import io.joynr.messaging.http.operation.HttpPost;
import io.joynr.messaging.http.operation.HttpRequestFactory;
import java.io.IOException;
import java.net.URI;
import javax.inject.Inject;
import joynr.system.RoutingTypes.ChannelAddress;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpMessageSender
implements IMessageSender {
    private static final Logger logger = LoggerFactory.getLogger(HttpMessageSender.class);
    private static final int DELAY_RECEIVER_NOT_STARTED_MS = 100;
    private static final String RECEIVER_NOT_STARTED_REASON = "cannot send until receiver is started";
    private final UrlResolver urlResolver;
    private final HttpRequestFactory httpRequestFactory;
    private final HttpConstants httpConstants;
    private final CloseableHttpClient httpclient;
    private final RequestConfig defaultRequestConfig;
    private final ObjectMapper objectMapper;
    private MessageReceiver messageReceiver;

    @Inject
    public HttpMessageSender(MessageReceiver messageReceiver, CloseableHttpClient httpclient, HttpRequestFactory httpRequestFactory, HttpConstants httpConstants, RequestConfig defaultRequestConfig, ObjectMapper objectMapper, UrlResolver urlResolver) {
        this.messageReceiver = messageReceiver;
        this.httpclient = httpclient;
        this.httpRequestFactory = httpRequestFactory;
        this.httpConstants = httpConstants;
        this.defaultRequestConfig = defaultRequestConfig;
        this.objectMapper = objectMapper;
        this.urlResolver = urlResolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void sendMessage(ChannelAddress address, String serializedMessage, FailureAction failureAction) {
        if (!this.messageReceiver.isReady()) {
            long delay_ms = 100L;
            failureAction.execute((Throwable)new JoynrDelayMessageException(delay_ms, RECEIVER_NOT_STARTED_REASON));
        }
        String sendUrl = this.urlResolver.getSendUrl(address.getMessagingEndpointUrl());
        logger.trace("SENDING: channelId: {} message: {}", (Object)sendUrl, (Object)serializedMessage);
        BasicHttpContext context = new BasicHttpContext();
        CloseableHttpResponse response = null;
        try {
            HttpPost httpPost = this.httpRequestFactory.createHttpPost(URI.create(sendUrl));
            httpPost.addHeader((Header)new BasicHeader(this.httpConstants.getHEADER_CONTENT_TYPE(), this.httpConstants.getAPPLICATION_JSON() + ";charset=UTF-8"));
            httpPost.setEntity((HttpEntity)new StringEntity(serializedMessage, "UTF-8"));
            RequestConfig.Builder requestConfigBuilder = RequestConfig.copy((RequestConfig)this.defaultRequestConfig);
            requestConfigBuilder.setConnectionRequestTimeout(this.httpConstants.getSEND_MESSAGE_REQUEST_TIMEOUT());
            httpPost.setConfig(requestConfigBuilder.build());
            response = this.httpclient.execute((HttpUriRequest)httpPost, (HttpContext)context);
            StatusLine statusLine = response.getStatusLine();
            int statusCode = statusLine.getStatusCode();
            String statusText = statusLine.getReasonPhrase();
            switch (statusCode) {
                case 200: 
                case 201: {
                    logger.trace("SENT: channelId {} message: {}", (Object)sendUrl, (Object)serializedMessage);
                    return;
                }
                case 400: {
                    HttpEntity entity = response.getEntity();
                    if (entity == null) {
                        failureAction.execute((Throwable)new JoynrCommunicationException("Error in HttpMessageSender. No further reason found in message body"));
                        return;
                    }
                    String body = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                    JoynrMessagingError error = (JoynrMessagingError)this.objectMapper.readValue(body, JoynrMessagingError.class);
                    JoynrMessagingErrorCode joynrMessagingErrorCode = JoynrMessagingErrorCode.getJoynrMessagingErrorCode((int)error.getCode());
                    logger.error(error.toString());
                    switch (joynrMessagingErrorCode) {
                        case JOYNRMESSAGINGERROR_CHANNELNOTFOUND: {
                            failureAction.execute((Throwable)new JoynrChannelMissingException("Channel does not exist. Status: " + statusCode + " error: " + error.getCode() + "reason:" + error.getReason()));
                            return;
                        }
                    }
                    failureAction.execute((Throwable)new JoynrCommunicationException("Error in HttpMessageSender: " + statusText + body + " error: " + error.getCode() + "reason:" + error.getReason()));
                    return;
                }
                default: {
                    failureAction.execute((Throwable)new JoynrCommunicationException("Unknown Error in HttpMessageSender: " + statusText + " statusCode: " + statusCode));
                    return;
                }
            }
        }
        catch (JoynrShutdownException e) {
            failureAction.execute((Throwable)new JoynrMessageNotSentException("Message not sent to: " + address, (Throwable)e));
            return;
        }
        catch (Exception e) {
            failureAction.execute((Throwable)new JoynrCommunicationException(e.getClass().getName() + "Exception while communicating. error: " + e.getMessage()));
            return;
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public void shutdown() {
        try {
            this.httpclient.close();
        }
        catch (IOException e) {
            logger.error("error closing HTTP client: {}", (Object)e.getMessage());
        }
    }
}

