/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.http.operation;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import io.joynr.messaging.MessagingSettings;
import io.joynr.messaging.http.operation.HttpConstants;
import java.util.Properties;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;

public class HttpDefaultRequestConfigProvider
implements Provider<RequestConfig> {
    private final RequestConfig defaultRequestConfig;

    @Inject
    public HttpDefaultRequestConfigProvider(MessagingSettings settings, @Named(value="joynr.properties") Properties properties, HttpConstants httpConstants) {
        RequestConfig.Builder configBuilder = RequestConfig.custom().setStaleConnectionCheckEnabled(true).setConnectionRequestTimeout(httpConstants.getHTTP_REQUEST_TIMEOUT_MS()).setConnectTimeout(httpConstants.getHTTP_CONNECTION_TIMEOUT_MS());
        String proxyHost = properties.getProperty("http.proxyhost");
        if (proxyHost != null) {
            int proxyPort = 8080;
            try {
                proxyPort = Integer.parseInt(properties.getProperty("http.proxyport"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            HttpHost proxy = new HttpHost(proxyHost, proxyPort);
            configBuilder.setProxy(proxy);
        }
        this.defaultRequestConfig = configBuilder.build();
    }

    public RequestConfig get() {
        return this.defaultRequestConfig;
    }
}

