/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.http.operation;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.joynr.exceptions.JoynrChannelMissingException;
import io.joynr.exceptions.JoynrCommunicationException;
import io.joynr.exceptions.JoynrShutdownException;
import io.joynr.messaging.MessageArrivedListener;
import io.joynr.messaging.MessagingSettings;
import io.joynr.messaging.datatypes.JoynrMessagingError;
import io.joynr.messaging.datatypes.JoynrMessagingErrorCode;
import io.joynr.messaging.http.operation.HttpConstants;
import io.joynr.messaging.http.operation.HttpGet;
import io.joynr.messaging.http.operation.HttpRequestFactory;
import io.joynr.messaging.util.Utilities;
import java.io.IOException;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import joynr.JoynrMessage;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LongPollChannel {
    private static final Logger logger = LoggerFactory.getLogger(LongPollChannel.class);
    final SimpleDateFormat format = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss.SSS");
    public static final long LONGPOLLING_RETRY_INTERVAL_SECS = 5L;
    private CloseableHttpClient httpclient;
    private boolean shutdown = false;
    private MessageArrivedListener messageArrivedListener;
    private final ObjectMapper objectMapper;
    private String id = "";
    private Lock statusLock = new ReentrantLock();
    private Condition statusChanged = this.statusLock.newCondition();
    private Boolean longPollingDisabled;
    private MessagingSettings settings;
    private HttpConstants httpConstants;
    private String receiverId;
    private HttpGet httpget;
    protected int statusCode;
    private String statusText;
    private RequestConfig defaultRequestConfig;
    private HttpRequestFactory httpRequestFactory;
    private ExecutorService messageReceiverExecutor;

    public LongPollChannel(CloseableHttpClient httpclient, RequestConfig defaultRequestConfig, Boolean longPollingDisabled, MessageArrivedListener messageArrivedListener, ObjectMapper objectMapper, MessagingSettings settings, HttpConstants httpConstants, String channelId, String receiverId, HttpRequestFactory httpRequestFactory) {
        this.httpclient = httpclient;
        this.defaultRequestConfig = defaultRequestConfig;
        this.longPollingDisabled = longPollingDisabled;
        this.messageArrivedListener = messageArrivedListener;
        this.objectMapper = objectMapper;
        this.settings = settings;
        this.httpConstants = httpConstants;
        this.receiverId = receiverId;
        this.httpRequestFactory = httpRequestFactory;
        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("joynr.LongPollChannel-%d").build();
        this.messageReceiverExecutor = Executors.newCachedThreadPool(namedThreadFactory);
    }

    /*
     * Unable to fully structure code
     */
    public Void longPollLoop() throws JoynrShutdownException {
        LongPollChannel.logger.debug("LongPollingChannel OPENING CHANNEL: {} ", (Object)this.id);
        try {
            while (true) lbl-1000:
            // 3 sources

            {
                if (this.shutdown) {
                    throw new JoynrShutdownException("shutting down");
                }
                if (this.longPollingDisabled.booleanValue()) {
                    try {
                        this.statusLock.lockInterruptibly();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new JoynrShutdownException("INTERRUPTED. Shutting down");
                    }
                    LongPollChannel.logger.trace("Waiting for long polling to be resumed.");
                    this.statusChanged.awaitUninterruptibly();
                    continue;
                }
                this.longPoll();
                try {
                    Thread.sleep(10L);
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new JoynrShutdownException("INTERRUPTED. Shutting down");
                }
                break;
            }
        }
        catch (Throwable var2_3) {
            LongPollChannel.logger.info("LongPollingChannel CHANNEL: " + this.id + " long poll loop exited");
            throw var2_3;
        }
        {
            ** while (true)
        }
    }

    private void longPoll() {
        String responseBody = null;
        if (this.shutdown) {
            return;
        }
        final String asciiString = this.httpget.getURI().toASCIIString();
        try {
            responseBody = (String)this.httpclient.execute((HttpUriRequest)this.httpget, (ResponseHandler)new ResponseHandler<String>(){

                public String handleResponse(HttpResponse response) throws IOException {
                    HttpEntity entity = response.getEntity();
                    String body = entity == null ? null : EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                    LongPollChannel.this.statusCode = response.getStatusLine().getStatusCode();
                    LongPollChannel.this.statusText = response.getStatusLine().getReasonPhrase();
                    logger.debug("Long poll returned: {} reason: url {}", (Object)LongPollChannel.this.statusCode, (Object)asciiString);
                    return body;
                }
            });
        }
        catch (IllegalStateException e) {
            logger.error("IllegalStateException in long poll: {} message: {}", (Object)asciiString, (Object)e.getMessage());
            throw new JoynrShutdownException(e.getMessage(), (Exception)e);
        }
        catch (Exception e) {
            logger.debug("Exception in long poll: " + asciiString, (Throwable)e);
            this.delay();
            return;
        }
        switch (this.statusCode) {
            case 200: {
                this.notifyDispatcher(responseBody);
                break;
            }
            case 404: {
                logger.error(responseBody);
                this.delay();
                throw new JoynrChannelMissingException("Not found");
            }
            case 400: {
                if (responseBody != null) {
                    try {
                        JoynrMessagingError error = (JoynrMessagingError)this.objectMapper.readValue(responseBody, JoynrMessagingError.class);
                        JoynrMessagingErrorCode joynrMessagingErrorCode = JoynrMessagingErrorCode.getJoynrMessagingErrorCode((int)error.getCode());
                        logger.error(error.toString());
                        switch (joynrMessagingErrorCode) {
                            case JOYNRMESSAGINGERROR_CHANNELNOTFOUND: {
                                throw new JoynrChannelMissingException(error.getReason());
                            }
                        }
                        throw new JoynrCommunicationException(error.getReason());
                    }
                    catch (IOException e) {
                        throw new JoynrCommunicationException(this.statusText, (Throwable)e);
                    }
                }
            }
            default: {
                this.delay();
            }
        }
    }

    private void notifyDispatcher(String responseBody) {
        if (responseBody == null || responseBody.length() <= 0) {
            return;
        }
        List listOfJsonStrings = Utilities.splitJson((String)responseBody);
        logger.info("LongPollingChannel CHANNEL: {} messages received: {}", (Object)listOfJsonStrings.size());
        for (String json : listOfJsonStrings) {
            try {
                final JoynrMessage message = (JoynrMessage)this.objectMapper.readValue(json, JoynrMessage.class);
                if (message != null) {
                    this.messageReceiverExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            logger.info("ARRIVED {} messageId: {} type: {} from: {} to: {} header: {}", (Object[])new String[]{LongPollChannel.this.httpget.getURI().toString(), message.getId(), message.getType(), message.getHeaderValue("from"), message.getHeaderValue("to"), message.getHeader().toString()});
                            logger.debug("\r\n<<<<<<<<<<<<<<<<<\r\n:{}", (Object)message.toLogMessage());
                            LongPollChannel.this.messageArrivedListener.messageArrived(message);
                        }
                    });
                    continue;
                }
                logger.warn("LongPollingChannel CHANNEL: {} message was null", (Object)this.id);
                this.messageArrivedListener.error(null, (Throwable)new JoynrCommunicationException("LongPollingChannel CHANNEL: {} message was null"));
            }
            catch (IOException e) {
                logger.error("error parsing JSON", (Throwable)e);
                logger.error("CHANNEL: {} Error converting the JSON into a Message object, message could not be passed to dispatcher. \nResponse body was: " + json, (Object)this.id);
            }
        }
    }

    public void shutdown() {
        if (this.httpget != null && this.httpget.getURI() != null) {
            logger.info("SHUTTING down long poll for {}", (Object)this.httpget.getURI().toASCIIString());
        }
        this.shutdown = true;
        if (this.httpclient != null) {
            try {
                this.httpclient.close();
            }
            catch (IOException e) {
                logger.error("error closing http client", (Throwable)e);
            }
        }
        logger.debug("LongPollingChannel CHANNEL: {} SHUT DOWN", (Object)this.id);
    }

    public void resume() {
        try {
            this.statusLock.lockInterruptibly();
            this.httpget.reset();
            this.setLongPollingDisabled(false);
            this.statusChanged.signal();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
        finally {
            this.statusLock.unlock();
        }
    }

    public void suspend() {
        try {
            this.statusLock.lockInterruptibly();
            this.setLongPollingDisabled(true);
            this.httpget.abort();
        }
        catch (InterruptedException e) {
            return;
        }
        finally {
            this.statusLock.unlock();
        }
    }

    public boolean isLongPollingDisabled() {
        return this.longPollingDisabled;
    }

    private void setLongPollingDisabled(boolean longPollingDisabled) {
        this.longPollingDisabled = longPollingDisabled;
    }

    public void setChannelUrl(String channelUrl) {
        this.httpget = this.httpRequestFactory.createHttpGet(URI.create(channelUrl));
        RequestConfig.Builder requestConfigBuilder = RequestConfig.copy((RequestConfig)this.defaultRequestConfig);
        this.httpget.setConfig(requestConfigBuilder.build());
        this.httpget.setHeader(this.httpConstants.getHEADER_X_ATMOSPHERE_TRACKING_ID(), this.receiverId);
        this.id = channelUrl.length() > 15 ? "..." + channelUrl.substring(channelUrl.length() - 15) : channelUrl;
    }

    private void delay() {
        try {
            Thread.sleep(this.settings.getLongPollRetryIntervalMs());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

