/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.http.operation;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import io.joynr.exceptions.JoynrChannelMissingException;
import io.joynr.exceptions.JoynrShutdownException;
import io.joynr.messaging.MessageArrivedListener;
import io.joynr.messaging.MessagingSettings;
import io.joynr.messaging.ReceiverStatusListener;
import io.joynr.messaging.http.operation.HttpConstants;
import io.joynr.messaging.http.operation.HttpDelete;
import io.joynr.messaging.http.operation.HttpGet;
import io.joynr.messaging.http.operation.HttpPost;
import io.joynr.messaging.http.operation.HttpRequestFactory;
import io.joynr.messaging.http.operation.LongPollChannel;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import javax.annotation.Nullable;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class LongPollingChannelLifecycle {
    private static final Logger logger = LoggerFactory.getLogger(LongPollingChannelLifecycle.class);
    private String channelUrl = null;
    private final String channelId;
    @Inject
    private MessagingSettings settings;
    ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("joynr.LongPoll-%d").build();
    private ExecutorService channelMonitorExecutorService = Executors.newFixedThreadPool(1, this.namedThreadFactory);
    private LongPollChannel longPolling;
    private final ObjectMapper objectMapper;
    private boolean longPollingDisabled;
    private boolean started = false;
    private boolean channelCreated = false;
    private HttpConstants httpConstants;
    private String receiverId;
    private CloseableHttpClient httpclient;
    private RequestConfig defaultRequestConfig;
    private Future<Void> longPollingFuture;
    private HttpRequestFactory httpRequestFactory;

    @Inject
    @Nullable
    public LongPollingChannelLifecycle(CloseableHttpClient httpclient, RequestConfig defaultRequestConfig, @Named(value="joynr.messaging.channelid") String channelId, @Named(value="joynr.messaging.receiverid") String receiverId, ObjectMapper objectMapper, HttpConstants httpConstants, HttpRequestFactory httpRequestFactory) {
        this.httpclient = httpclient;
        this.defaultRequestConfig = defaultRequestConfig;
        this.channelId = channelId;
        this.receiverId = receiverId;
        this.objectMapper = objectMapper;
        this.httpConstants = httpConstants;
        this.httpRequestFactory = httpRequestFactory;
    }

    public synchronized void startLongPolling(final MessageArrivedListener messageArrivedListener, final ReceiverStatusListener ... receiverStatusListeners) {
        if (this.channelMonitorExecutorService == null) {
            throw new JoynrShutdownException("Channel Monitor already shutdown");
        }
        if (this.started) {
            throw new IllegalStateException("only one long polling thread can be started per ChannelMonitor");
        }
        this.started = true;
        Callable<Void> channelLifecycleCallable = new Callable<Void>(){

            @Override
            public Void call() {
                try {
                    LongPollingChannelLifecycle.this.checkServerTime();
                    int maxRetries = LongPollingChannelLifecycle.this.settings.getMaxRetriesCount();
                    while (true) {
                        LongPollingChannelLifecycle.this.channelCreated = false;
                        LongPollingChannelLifecycle.this.createChannelLoop(maxRetries);
                        for (ReceiverStatusListener statusListener : receiverStatusListeners) {
                            statusListener.receiverStarted();
                        }
                        if (!LongPollingChannelLifecycle.this.isChannelCreated()) {
                            String message = "registerMessageReceiver channelId: " + LongPollingChannelLifecycle.this.channelId + " error occured. Exiting.";
                            logger.error(message);
                            for (ReceiverStatusListener statusListener : receiverStatusListeners) {
                                statusListener.receiverException((Throwable)new JoynrShutdownException(message));
                            }
                        }
                        LongPollingChannelLifecycle.this.longPollLoop(messageArrivedListener, maxRetries);
                    }
                }
                catch (Throwable throwable) {
                    LongPollingChannelLifecycle.this.started = false;
                    throw throwable;
                }
            }
        };
        this.longPollingFuture = this.channelMonitorExecutorService.submit(channelLifecycleCallable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkServerTime() {
        CloseableHttpResponse response = null;
        try {
            String url = this.settings.getBounceProxyUrl().buildTimeCheckUrl();
            long serverTime = 0L;
            long localTimeBeforeRequest = System.currentTimeMillis();
            HttpGet getTime = this.httpRequestFactory.createHttpGet(URI.create(url));
            getTime.setConfig(this.defaultRequestConfig);
            response = this.httpclient.execute((HttpUriRequest)getTime);
            StatusLine statusLine = response.getStatusLine();
            int statusCode = statusLine.getStatusCode();
            if (statusCode != 200) {
                logger.error("CheckServerTime: Bounce Proxy not reached: " + url + " Status " + statusCode + " Reason " + statusLine.getReasonPhrase());
                return;
            }
            long localTimeAfterRequest = System.currentTimeMillis();
            long localTime = (localTimeBeforeRequest + localTimeAfterRequest) / 2L;
            try {
                serverTime = Long.parseLong(EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8"));
            }
            catch (Exception e) {
                logger.error("CheckServerTime: could not parse server time: {}", (Object)e.getMessage());
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (IOException e2) {
                        logger.error("CheckServerTime: error {}", (Object)e2.getMessage());
                    }
                }
                return;
            }
            long diff = Math.abs(serverTime - localTime);
            logger.debug("############ Server Time: " + serverTime + " vs. Local Time: " + localTime + " diff: " + diff);
            if (Math.abs(diff) > 500L) {
                logger.error("CheckServerTime: TIME DIFFERENCE TOO LARGE. PLEASE SYNC CLOCKS: diff=" + diff);
            } else {
                logger.info("CheckServerTime: time difference to server is " + diff);
            }
        }
        catch (Exception e) {
            logger.error("CheckServerTime: error {}", (Object)e.getMessage());
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    logger.error("CheckServerTime: error {}", (Object)e.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int longPollLoop(MessageArrivedListener messageArrivedListener, int retries) throws JoynrShutdownException {
        while (retries > 0) {
            logger.info("LONG POLL LOOP: Start: retries: {}", (Object)retries);
            --retries;
            try {
                if (this.channelUrl == null) {
                    logger.error("openChannel channelId: {} channelUrl cannot be NULL", (Object)this.channelId);
                    throw new IllegalArgumentException("openChannel channelId: " + this.channelId + " channelUrl cannot be NULL");
                }
                if (!this.started) {
                    String errorMsg = "openChannel " + this.channelId + "failed: ChannelMonitor is shutdown";
                    logger.error(errorMsg);
                    throw new JoynrShutdownException(errorMsg);
                }
                LongPollingChannelLifecycle errorMsg = this;
                synchronized (errorMsg) {
                    this.longPolling = new LongPollChannel(this.httpclient, this.defaultRequestConfig, this.longPollingDisabled, messageArrivedListener, this.objectMapper, this.settings, this.httpConstants, this.channelId, this.receiverId, this.httpRequestFactory);
                }
                this.longPolling.setChannelUrl(this.channelUrl);
                this.longPolling.longPollLoop();
                return retries;
            }
            catch (JoynrChannelMissingException e) {
                logger.error("LONG POLL LOOP: error in long poll: {}", (Object)e.getMessage());
                break;
            }
            catch (RejectedExecutionException e) {
                logger.error("LONG POLL LOOP: error in long poll: {}", (Object)e.getMessage());
                long waitMs = this.settings.getLongPollRetryIntervalMs();
                logger.info("LONG POLL LOOP: waiting for: {}", (Object)waitMs);
                try {
                    Thread.sleep(waitMs);
                }
                catch (InterruptedException e1) {
                    throw new JoynrShutdownException("INTERRUPT. Shutting down");
                }
            }
        }
        return retries;
    }

    private int createChannelLoop(int retries) {
        while (this.started && !this.channelCreated) {
            this.channelCreated = this.createChannel();
            if (this.channelCreated || retries <= 0) break;
            try {
                long waitMs = this.settings.getLongPollRetryIntervalMs();
                Thread.sleep(waitMs);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            --retries;
        }
        return retries;
    }

    public synchronized void suspend() {
        this.longPollingDisabled = true;
        if (this.longPolling != null) {
            logger.debug("Suspending longPollingCallable.");
            this.longPolling.suspend();
        } else {
            logger.debug("Called suspend before longPollingCallable was created.");
        }
    }

    public synchronized void resume() {
        this.longPollingDisabled = false;
        if (this.longPolling != null) {
            this.longPolling.resume();
        }
    }

    @SuppressWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="Shutdown doesn't have to synchronize the access to channelMonitorExecutorService")
    public void shutdown() {
        this.started = false;
        logger.debug("ChannelMonitor channel: {} SHUTDOWN...", (Object)this.channelId);
        if (this.channelMonitorExecutorService != null) {
            logger.debug("ChannelMonitor channel: {} SHUTDOWN channelMonitorExecutorService", (Object)this.channelId);
            this.channelMonitorExecutorService.shutdownNow();
            this.channelMonitorExecutorService = null;
        }
        if (this.longPolling != null) {
            this.longPolling.shutdown();
        }
        if (this.longPollingFuture != null) {
            this.longPollingFuture.cancel(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean createChannel() {
        String url = this.settings.getBounceProxyUrl().buildCreateChannelUrl(this.channelId);
        HttpPost postCreateChannel = this.httpRequestFactory.createHttpPost(URI.create(url.trim()));
        postCreateChannel.setConfig(this.defaultRequestConfig);
        postCreateChannel.addHeader(this.httpConstants.getHEADER_X_ATMOSPHERE_TRACKING_ID(), this.receiverId);
        postCreateChannel.addHeader(this.httpConstants.getHEADER_CONTENT_TYPE(), this.httpConstants.getAPPLICATION_JSON());
        this.channelUrl = null;
        CloseableHttpResponse response = null;
        boolean created = false;
        try {
            response = this.httpclient.execute((HttpUriRequest)postCreateChannel);
            StatusLine statusLine = response.getStatusLine();
            int statusCode = statusLine.getStatusCode();
            String reasonPhrase = statusLine.getReasonPhrase();
            switch (statusCode) {
                case 200: 
                case 201: {
                    try {
                        Header locationHeader = response.getFirstHeader(this.httpConstants.getHEADER_LOCATION());
                        this.channelUrl = locationHeader != null ? locationHeader.getValue() : null;
                        break;
                    }
                    catch (Exception e) {
                        throw new JoynrChannelMissingException("channel url was null");
                    }
                }
                default: {
                    logger.error("createChannel channelId: {} failed. status: {} reason: {}", (Object[])new String[]{this.channelId, Integer.toString(statusCode), reasonPhrase});
                    throw new JoynrChannelMissingException("channel url was null");
                }
            }
            created = true;
            logger.info("createChannel channelId: {} returned channelUrl {}", (Object)this.channelId, (Object)this.channelUrl);
        }
        catch (ClientProtocolException e) {
            logger.error("createChannel ERROR reason: {}", (Object)e.getMessage());
        }
        catch (IOException e) {
            logger.error("createChannel ERROR reason: {}", (Object)e.getMessage());
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    logger.error("createChannel ERROR reason: {}", (Object)e.getMessage());
                }
            }
        }
        return created;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressWarnings(value={"SWL_SLEEP_WITH_LOCK_HELD"}, justification="Other synchronized methods should block while deleting a channel")
    synchronized boolean deleteChannel(int retries) {
        if (this.channelUrl == null) {
            return true;
        }
        if (retries < 0) {
            logger.info("delete channel: {} retries expired ", (Object)this.channelUrl);
            return false;
        }
        logger.info("trying to delete channel: " + this.channelUrl);
        try {
            while (retries > 0) {
                CloseableHttpResponse response = null;
                try {
                    HttpDelete httpDelete = this.httpRequestFactory.createHttpDelete(URI.create(this.channelUrl));
                    response = this.httpclient.execute((HttpUriRequest)httpDelete);
                    int statusCode = response.getStatusLine().getStatusCode();
                    if (statusCode == 200 || statusCode == 204) {
                        logger.debug("DELETE CHANNEL: {} completed successfully. status:{}", (Object)this.channelUrl, (Object)statusCode);
                        this.channelUrl = null;
                        boolean bl = true;
                        return bl;
                    }
                }
                catch (IllegalStateException e) {
                    logger.error("DELETE: CHANNEL " + this.channelUrl + "failed. Cannot retry: ", (Object)e.getMessage());
                    boolean bl = false;
                    return bl;
                }
                catch (Exception e) {
                    logger.error("DELETE: CHANNEL " + this.channelUrl + "failed retries: " + retries, (Object)e.getMessage());
                }
                finally {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                if (retries > 1) {
                    try {
                        Thread.sleep(this.settings.getLongPollRetryIntervalMs());
                    }
                    catch (InterruptedException e) {
                        return false;
                    }
                }
                --retries;
            }
            return false;
        }
        catch (IllegalArgumentException e) {
            logger.error("DELETE: CHANNEL {} attempted on channelUrl:\"{}\" which is not a valid channelUrl", (Object)this.channelId, (Object)this.channelUrl);
        }
        return false;
    }

    public String getChannelUrl() {
        return this.channelUrl;
    }

    public String getChannelId() {
        return this.channelId;
    }

    @SuppressWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="isStarted is just a getter for the flag")
    public boolean isStarted() {
        return this.started;
    }

    public boolean isChannelCreated() {
        return this.channelCreated;
    }
}

