/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.http.operation;

import com.google.common.collect.ObjectArrays;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.SettableFuture;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import io.joynr.exceptions.JoynrShutdownException;
import io.joynr.messaging.MessageArrivedListener;
import io.joynr.messaging.MessageReceiver;
import io.joynr.messaging.MessagingSettings;
import io.joynr.messaging.ReceiverStatusListener;
import io.joynr.messaging.http.operation.ChannelCreatedListener;
import io.joynr.messaging.http.operation.LongPollingChannelLifecycle;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class LongPollingMessageReceiver
implements MessageReceiver {
    public static final String MESSAGE_RECEIVER_THREADNAME_PREFIX = "MessageReceiverThread";
    private static final Logger logger = LoggerFactory.getLogger(LongPollingMessageReceiver.class);
    ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("joynr.MessageReceiver-%d").build();
    protected final MessagingSettings settings;
    protected final LongPollingChannelLifecycle channelMonitor;
    private final String channelId;
    private boolean shutdown = false;
    private Object shutdownSynchronizer = new Object();
    private Set<ChannelCreatedListener> channelCreatedListeners = new HashSet<ChannelCreatedListener>(1);

    @Inject
    public LongPollingMessageReceiver(LongPollingChannelLifecycle channelMonitor, MessagingSettings settings) {
        this.channelMonitor = channelMonitor;
        this.settings = settings;
        this.channelId = channelMonitor.getChannelId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Future<Void> start(MessageArrivedListener messageListener, ReceiverStatusListener ... receiverStatusListeners) {
        Object object = this.shutdownSynchronizer;
        synchronized (object) {
            if (this.shutdown) {
                throw new JoynrShutdownException("Cannot register Message Listener: " + messageListener + ": LongPollingMessageReceiver is already shutting down");
            }
        }
        if (this.isStarted()) {
            return Futures.immediateFailedFuture((Throwable)new IllegalStateException("receiver is already started"));
        }
        final SettableFuture channelCreatedFuture = SettableFuture.create();
        ReceiverStatusListener[] statusListeners = (ReceiverStatusListener[])ObjectArrays.concat((Object)new ReceiverStatusListener(){

            public void receiverStarted() {
                if (LongPollingMessageReceiver.this.channelMonitor.isChannelCreated()) {
                    for (ChannelCreatedListener listener : LongPollingMessageReceiver.this.channelCreatedListeners) {
                        listener.channelCreated(LongPollingMessageReceiver.this.channelMonitor.getChannelUrl());
                    }
                    channelCreatedFuture.set(null);
                }
            }

            public void receiverException(Throwable e) {
                channelCreatedFuture.setException(e);
                LongPollingMessageReceiver.this.channelMonitor.shutdown();
            }
        }, (Object[])receiverStatusListeners);
        this.channelMonitor.startLongPolling(messageListener, statusListeners);
        return channelCreatedFuture;
    }

    @SuppressWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="shutdown is locked using the shutdownSynchronizer object")
    public void shutdown(boolean clear) {
        logger.info("SHUTTING DOWN long polling message receiver");
        if (clear) {
            this.deleteChannel();
        }
        if (this.channelMonitor != null) {
            this.channelMonitor.shutdown();
        }
    }

    public String getChannelId() {
        return this.channelId;
    }

    public boolean deleteChannel() {
        if (this.channelMonitor != null) {
            return this.channelMonitor.deleteChannel(this.settings.getMaxRetriesCount());
        }
        return false;
    }

    public boolean isStarted() {
        return this.channelMonitor.isStarted();
    }

    public boolean isReady() {
        return this.channelMonitor.isChannelCreated();
    }

    public void suspend() {
        logger.info("Suspending channelMonitor");
        this.channelMonitor.suspend();
    }

    public void resume() {
        this.channelMonitor.resume();
    }

    public void registerChannelCreatedListener(ChannelCreatedListener listener) {
        this.channelCreatedListeners.add(listener);
    }
}

