/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.resource.EpollProvider;
import io.lettuce.core.resource.EventLoopResources;
import io.lettuce.core.resource.KqueueProvider;
import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;

class Transports {
    Transports() {
    }

    static Class<? extends EventLoopGroup> eventLoopGroupClass() {
        if (NativeTransports.isSocketSupported()) {
            return NativeTransports.eventLoopGroupClass();
        }
        return NioEventLoopGroup.class;
    }

    static Class<? extends Channel> socketChannelClass() {
        if (NativeTransports.isSocketSupported()) {
            return NativeTransports.socketChannelClass();
        }
        return NioSocketChannel.class;
    }

    static class NativeTransports {
        static EventLoopResources RESOURCES = KqueueProvider.isAvailable() ? KqueueProvider.getResources() : EpollProvider.getResources();

        NativeTransports() {
        }

        static boolean isSocketSupported() {
            return EpollProvider.isAvailable() || KqueueProvider.isAvailable();
        }

        static Class<? extends Channel> socketChannelClass() {
            return RESOURCES.socketChannelClass();
        }

        static Class<? extends Channel> domainSocketChannelClass() {
            return RESOURCES.domainSocketChannelClass();
        }

        static Class<? extends EventLoopGroup> eventLoopGroupClass() {
            return RESOURCES.eventLoopGroupClass();
        }

        static void assertAvailable() {
            LettuceAssert.assertState(NativeTransports.isSocketSupported(), "A unix domain socket connections requires epoll or kqueue and neither is available");
        }
    }
}

