/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.docs.commons;

import io.micrometer.common.lang.Nullable;
import io.micrometer.common.util.internal.logging.InternalLogger;
import io.micrometer.common.util.internal.logging.InternalLoggerFactory;
import io.micrometer.docs.commons.EntryEnumConstantReader;
import io.micrometer.docs.commons.JavaSourceSearchHelper;
import io.micrometer.docs.commons.KeyNameEntry;
import io.micrometer.docs.commons.ParsingUtils;
import io.micrometer.docs.commons.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster.model.source.EnumConstantSource;
import org.jboss.forge.roaster.model.source.JavaEnumSource;
import org.jboss.forge.roaster.model.source.JavaSource;
import org.jboss.forge.roaster.model.source.MethodSource;

public abstract class AbstractSearchingFileVisitor
extends SimpleFileVisitor<Path> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractSearchingFileVisitor.class);
    protected final Pattern pattern;
    protected final JavaSourceSearchHelper searchHelper;

    public AbstractSearchingFileVisitor(Pattern pattern, JavaSourceSearchHelper searchHelper) {
        this.pattern = pattern;
        this.searchHelper = searchHelper;
    }

    @Override
    public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
        if (!this.pattern.matcher(path.toString()).matches()) {
            return FileVisitResult.CONTINUE;
        }
        if (!path.toString().endsWith(".java")) {
            return FileVisitResult.CONTINUE;
        }
        logger.debug("Parsing [" + path + "]");
        JavaSource javaSource = (JavaSource)Roaster.parse(JavaSource.class, (File)path.toFile());
        if (!javaSource.isEnum()) {
            return FileVisitResult.CONTINUE;
        }
        JavaEnumSource enumSource = (JavaEnumSource)javaSource;
        if (this.supportedInterfaces().stream().noneMatch(arg_0 -> ((JavaEnumSource)enumSource).hasInterface(arg_0))) {
            return FileVisitResult.CONTINUE;
        }
        logger.debug("Checking [" + javaSource.getName() + "]");
        if (enumSource.getMethods().size() > 0) {
            String message = String.format("The enum constants can define methods but the container enum class(%s) cannot define methods.", enumSource.getName());
            throw new RuntimeException(message);
        }
        if (enumSource.getEnumConstants().size() == 0) {
            return FileVisitResult.CONTINUE;
        }
        for (EnumConstantSource enumConstant : enumSource.getEnumConstants()) {
            if (enumConstant.getBody().getMethods().isEmpty()) continue;
            this.onEnumConstant(enumSource, enumConstant);
        }
        return FileVisitResult.CONTINUE;
    }

    public abstract Collection<Class<?>> supportedInterfaces();

    public abstract void onEnumConstant(JavaEnumSource var1, EnumConstantSource var2);

    protected void validateNameOrConvention(String name, @Nullable String conventionClassName, JavaEnumSource enclosingEnum) {
        if (StringUtils.hasText(name)) {
            if (conventionClassName != null) {
                throw new IllegalStateException("You can't declare both [getName()] and [getDefaultConvention()] methods at the same time, you have to chose only one. Problem occurred in [" + enclosingEnum.getName() + "] class");
            }
        } else if (conventionClassName == null) {
            throw new IllegalStateException("You have to set either [getName()] or [getDefaultConvention()] methods. In case of [" + enclosingEnum.getName() + "] you haven't defined any");
        }
    }

    protected <T> List<T> retrieveEnumValues(JavaSource<?> enclosingJavaSource, MethodSource<?> methodSource, EntryEnumConstantReader<?> converter) {
        ArrayList result = new ArrayList();
        Set<String> enumClassNames = ParsingUtils.readEnumClassNames(methodSource);
        for (String enumClassName : enumClassNames) {
            JavaSource<?> enclosingEnumClass = this.searchHelper.searchReferencingClass(enclosingJavaSource, enumClassName);
            if (enclosingEnumClass == null || !enclosingEnumClass.isEnum()) {
                throw new IllegalStateException("Cannot find enum class with name [" + enumClassName + "]");
            }
            result.addAll(ParsingUtils.retrieveModelsFromEnum((JavaEnumSource)enclosingEnumClass, converter));
        }
        return result;
    }

    protected List<String> validatePrefixOnTags(String prefix, List<KeyNameEntry> tags, String enumName, String enclosingClassName) {
        ArrayList<String> messages = new ArrayList<String>();
        for (KeyNameEntry tag : tags) {
            String tagName = tag.getName();
            if (StringUtils.hasText(tagName) && tagName.startsWith(prefix)) continue;
            String message = String.format("\tName <%s> in class <%s> has the following prefix <%s> and following invalid tag keys %s", enumName, enclosingClassName, prefix, tagName);
            messages.add(message);
        }
        return messages;
    }

    protected static class NameInfo {
        private final String name;
        private final String nameOrigin;

        public NameInfo(String name, String nameOrigin) {
            this.name = name;
            this.nameOrigin = nameOrigin;
        }

        public String getName() {
            return this.name;
        }

        public String getNameOrigin() {
            return this.nameOrigin;
        }
    }
}

