/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.docs.commons;

import io.micrometer.common.docs.KeyName;
import io.micrometer.docs.commons.EntryEnumConstantReader;
import io.micrometer.docs.commons.KeyNameEntry;
import io.micrometer.docs.commons.ParsingUtils;
import io.micrometer.docs.commons.utils.AsciidocUtils;
import io.micrometer.docs.commons.utils.Assert;
import org.jboss.forge.roaster.model.source.EnumConstantSource;

public class KeyNameEnumConstantReader
implements EntryEnumConstantReader<KeyNameEntry> {
    public static final KeyNameEnumConstantReader INSTANCE = new KeyNameEnumConstantReader();

    @Override
    public Class<?> getRequiredClass() {
        return KeyName.class;
    }

    @Override
    public KeyNameEntry apply(EnumConstantSource enumConstantSource) {
        String description = AsciidocUtils.javadocToAsciidoc(enumConstantSource.getJavaDoc());
        String value = ParsingUtils.enumMethodValue(enumConstantSource, "asString");
        String isRequired = ParsingUtils.enumMethodValue(enumConstantSource, "isRequired");
        Assert.notNull(value, "KeyName enum constants require readable asString().");
        boolean required = !"false".equals(isRequired);
        KeyNameEntry model = new KeyNameEntry();
        model.setName(value);
        model.setDescription(description);
        model.setRequired(required);
        return model;
    }
}

