/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.docs.conventions;

import com.github.jknack.handlebars.Template;
import io.micrometer.common.util.internal.logging.InternalLogger;
import io.micrometer.common.util.internal.logging.InternalLoggerFactory;
import io.micrometer.docs.commons.JavaSourceSearchHelper;
import io.micrometer.docs.commons.templates.HandlebarsUtils;
import io.micrometer.docs.conventions.ObservationConventionEntry;
import io.micrometer.docs.conventions.ObservationConventionSearchingFileVisitor;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class ObservationConventionsDocGenerator {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ObservationConventionsDocGenerator.class);
    private final File projectRoot;
    private final Pattern inclusionPattern;
    private final String templateLocation;
    private final Path output;

    public ObservationConventionsDocGenerator(File projectRoot, Pattern inclusionPattern, String templateLocation, Path output) {
        this.projectRoot = projectRoot;
        this.inclusionPattern = inclusionPattern;
        this.templateLocation = templateLocation;
        this.output = output;
    }

    public void generate() {
        Path path = this.projectRoot.toPath();
        logger.debug("Path is [" + this.projectRoot.getAbsolutePath() + "]. Inclusion pattern is [" + this.inclusionPattern + "]");
        TreeSet<ObservationConventionEntry> observationConventionEntries = new TreeSet<ObservationConventionEntry>();
        JavaSourceSearchHelper searchHelper = JavaSourceSearchHelper.create(this.projectRoot.toPath(), this.inclusionPattern);
        ObservationConventionSearchingFileVisitor fv = new ObservationConventionSearchingFileVisitor(this.inclusionPattern, observationConventionEntries, searchHelper);
        try {
            Files.walkFileTree(path, fv);
            this.printObservationConventionsAdoc(observationConventionEntries);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private void printObservationConventionsAdoc(TreeSet<ObservationConventionEntry> entries) throws IOException {
        List globals = entries.stream().filter(e -> e.getType() == ObservationConventionEntry.Type.GLOBAL).collect(Collectors.toList());
        List locals = entries.stream().filter(e -> e.getType() == ObservationConventionEntry.Type.LOCAL).collect(Collectors.toList());
        Template template = HandlebarsUtils.createTemplate(this.templateLocation);
        HashMap map = new HashMap();
        map.put("globals", globals);
        map.put("locals", locals);
        String result = template.apply(map);
        Files.write(this.output, result.getBytes(), new OpenOption[0]);
    }
}

